package com.af.component;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;

/**
 * @Author: JoeCdy
 * @Description: 读取配置文件
 * @Date: Created in 15:50 2022/8/12
 */
public class Config {
    /**
     * 微信wechatConfig参数对象, 用它动态获取数据
     */
    public static PropertiesConfiguration wechatConfig;

    static {
        try {
            wechatConfig = new PropertiesConfiguration("wechatConfig.properties");
            // 自动重新加载
            wechatConfig.setReloadingStrategy(new FileChangedReloadingStrategy());
        } catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }
}
