select
	cast(t.f_userfiles_id as { entity.findDialect() == $SqlServer$: $varchar$,$varchar2(50)$}) f_userfiles_id,		--表编号
    t.f_userinfo_id, --用户号
	t.f_meterid,								--用户号
	t.f_price_id,
	{ entity.findDialect() == $SqlServer$: $CONVERT(varchar(100),t.f_perform_date,112)$,$TO_CHAR(t.f_perform_date, 'yyyymmdd')$} f_perform_date,							--生效时间
	isnull(t.f_version, 0) f_version,                --气价版本号
	SUM({ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(gasnums,0)) gasnums,				--总购气次数
	SUM({ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(f_pregas,0)) f_pregas,			--表累计购气量
	SUM({ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(f_collection,0)) f_collection,	--表累计购气金额
	SUM({ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(f_pregasall,0)) f_pregasall,		--户累计购气量
	SUM({ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(bc,0)) bc,						--本次购气量
	SUM({ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(bcje, 0)) bcje,					--本次购气金额
	SUM({ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(sc,0)) sc,						--上次购气量
	SUM({ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(scje,0)) scje,					--上次购气金额
	SUM({ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(ssc,0)) ssc,						--上上次购气量
	SUM({ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(sscje,0)) sscje,					--上上次购气金额
	cast(t.stairprice as { entity.findDialect() == $SqlServer$: $varchar$,$varchar2(50)$}) stairprice,	--单价
	cast(t.stairamount as { entity.findDialect() == $SqlServer$: $varchar$,$varchar2(50)$}) stairamount	--气量
from (
	select
		u.f_userfiles_id,
		u.f_userinfo_id,
		u.f_meterid,
		s.f_price_id,
		d.stairprice,
		s.f_perform_date,
		s.f_version,
		{ entity.findDialect() == $SqlServer$: $substring(d.stairamount,0,len(stairamount)-(CHARINDEX(';',REVERSE(stairamount))-1))$,
		$substr(d.stairamount,0,length(stairamount)-INSTR(REVERSE(stairamount),';'))$} stairamount
	from
		(select f_userfiles_id,f_userinfo_id,f_meterid,f_price_id,f_filialeid from t_userfiles where f_card_id='{f_card_id}' and f_userfiles_id = '{f_userfiles_id}') u
	left join t_userinfo uinfo	 on u.f_userinfo_id=uinfo.f_userinfo_id
	left join
		(select id,f_price_id,f_perform_date,f_filialeid,f_version from t_stairprice where getdate()>=f_perform_date and getdate()<=f_end_date and f_state = '有效') s on u.f_price_id=s.f_price_id and u.f_filialeid = s.f_filialeid
	left join (
		select
			f_stairprice_id,
			{ entity.findDialect() == $SqlServer$: $SUBSTRING(stairprice,0,LEN(stairprice))$,
		$SUBSTR(stairprice,1,length(stairprice))$}
			 stairprice,
			 { entity.findDialect() == $SqlServer$: $SUBSTRING(stairamount,0,LEN(stairamount))$,
		$SUBSTR(stairamount,1,length(stairamount))$}
			 stairamount
		from (
			select
				f_stairprice_id,
				{ entity.findDialect() == $SqlServer$: $(select cast(f_price as varchar)+';' from t_detailprice where f_stairprice_id=d.f_stairprice_id for xml path(''))$,
				$listagg(f_price, ';') within group(order by f_stairprice_id)$}  stairprice,
				{ entity.findDialect() == $SqlServer$: $(select cast(f_gas as varchar)+';' from t_detailprice where f_stairprice_id=d.f_stairprice_id for xml path(''))$,
				$listagg(f_gas, ';') within group(order by f_stairprice_id)$}  stairamount
			from t_detailprice d group by f_stairprice_id
		) p
	 ) d on d.f_stairprice_id=s.id
) t
left join
(
--表累计购气量、总购气次数、户累计购气量
select
	u.f_userfiles_id,
	u.f_userinfo_id,
	f_times gasnums,
	f_total_gas as f_pregas,
  f_total_fee as f_collection,
	0 f_pregasall,--户累计购气量
	0 bc,
	0 bcje,
	0 sc,
	0 scje,
	0 ssc,
	0 sscje
from t_userfiles u
where u.f_card_id = '{f_card_id}' and u.f_userfiles_id = '{f_userfiles_id}'
union all
--上次购气量，上上次购气量,上次购气金额，上上次购气金额
select
	f_userfiles_id,
	f_userinfo_id,
	0 gasnums,
	0 f_pregas,
	0 f_collection,
	0 f_pregasall,
	SUM(bc) bc,		--本次购气量
	SUM(bcje) bcje,		--本次购气金额
	SUM(sc) sc,		--上次购气量
	SUM(scje) scje,		--上次购气金额
	SUM(ssc) ssc,	--上上次购气量
	SUM(sscje) sscje	--上上次购气金额
from(
	select
		f_userfiles_id,
		f_userinfo_id,
		case when row_num=1 then f_pregas else 0 end as bc,
		case when row_num=1 then f_preamount else 0 end as bcje,
		case when row_num=2 then f_pregas else 0 end as sc,
		case when row_num=2 then f_preamount else 0 end as scje,
		case when row_num=3 then f_pregas else 0 end as ssc,
		case when row_num=3 then f_preamount else 0 end as sscje
	from (
		select
			row_number()over(order by dates desc) as row_num,
			f_userfiles_id,
			f_userinfo_id,
			f_pregas,
			f_preamount
		from (
			select ts.dates,ts.f_userfiles_id,ts.f_userinfo_id,ts.f_pregas,ts.f_preamount from (
				select { entity.findDialect() == $SqlServer$: $top 20$,$$} f_operate_date dates,{ entity.findDialect() == $SqlServer$: $f_userfiles_id$,$to_number(f_userfiles_id) f_userfiles_id$},f_userinfo_id,f_pregas,f_preamount
				from t_sellinggas
				where f_card_id = '{f_card_id}' and f_userfiles_id = '{f_userfiles_id}' and f_state = '有效' { entity.findDialect() == $SqlServer$: $$,$and rownum<=3$}
				order by f_operate_date desc ) ts
			union all
			select tf.dates,tf.f_userfiles_id,tf.f_userinfo_id,tf.f_pregas,tf.f_preamount from (
				select { entity.findDialect() == $SqlServer$: $top 20$,$$} f_operate_date dates,f_userfiles_id,f_userinfo_id,f_pregas, f_preamount
				from t_fillgas
				where f_card_id = '{f_card_id}' and f_userfiles_id = '{f_userfiles_id}' and f_state = '有效' and f_type = '换表补气' { entity.findDialect() == $SqlServer$: $$,$and rownum<=3$}
				order by f_operate_date desc ) tf
		) s
	) a
) p group by f_userfiles_id,f_userinfo_id
) y on t.f_userfiles_id=y.f_userfiles_id
group by t.f_userfiles_id,t.f_userinfo_id,t.f_meterid,t.stairprice,t.stairamount,t.f_perform_date,t.f_price_id,t.f_version
