SELECT
	*
FROM
	(
		SELECT
			u1.f_userinfo_id,   --用户编号
			u1.f_user_name,		--用户姓名
			u1.f_user_phone,	--用户电话
			u1.f_address,		--地址
			u1.f_residential_area,			--小区
			u1.f_area,			--小区
			u1.f_slice_area,	--
			u1.f_user_type,		--用户类型
			u1.f_gasproperties,	--用气方式
			u2.f_balance,		--账户余额
			u2.f_tablebase,
			u2.f_last_tablebase,
			u2.f_filialeids,
			u2.f_outlets,
			{ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}
			({ entity.findDialect() == $SqlServer$: $CONVERT(varchar(100), u2.f_hand_date, 23)$,$TO_CHAR(TO_DATE(u2.f_hand_date, 'yyyy-mm-dd'))$},'') f_hand_date,		--欠费月份
			{ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(u2.sumoughtamount, 0) f_oughtamount,--欠费气量
			{ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(u2.sumoughtfee, 0) f_oughtfee,		--欠费金额
			zhinaday,
			value,
			{ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(sumzhinajin, 0) f_deplay,			--滞纳金
			{ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(u2.sumoughtfee, 0)+{ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(sumzhinajin, 0)-u2.f_balance qianfei  --实际欠费金额
		FROM
			t_userinfo u1
		LEFT JOIN (
			SELECT
				f_userinfo_id,						--用户编号
				f_hand_date,
				f_balance,
				f_tablebase,
				f_last_tablebase,
				f_filialeids,
				f_outlets,
				zhinaday,
				value,
				f_oughtamount sumoughtamount,	--欠费总气量
				f_oughtfee sumoughtfee,			--欠费总金额
				case when { entity.findDialect() == $SqlServer$: $isnull$,$NVL$}
				(zhinajin,0)>=f_oughtfee then f_oughtfee else { entity.findDialect() == $SqlServer$: $isnull$,$NVL$}
				(zhinajin,0) end  sumzhinajin	--欠费滞纳金合计
			FROM
				(
					SELECT
						h1.f_userinfo_id,
						h1.f_user_type,
						h1.f_oughtamount,
						h1.f_oughtfee,
						h1.f_tablebase,
						h1.f_last_tablebase,
						h1.f_filialeids,
						h1.f_outlets,
						h1.f_hand_date,
						{ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}
						(h2.f_balance,0) f_balance,
						CASE WHEN 
						{ entity.findDialect() == $SqlServer$: $DATEDIFF(dd,isnull(h1.f_end_date, getdate()),getdate())$,
						$trunc(sysdate-{ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(h1.f_end_date, sysdate))$}
						 < 0 
									THEN 0 ELSE 
									{ entity.findDialect() == $SqlServer$: $DATEDIFF(dd,isnull(h1.f_end_date, getdate()),getdate())$,
						$trunc(sysdate-{ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(h1.f_end_date, sysdate))$}
									END zhinaday,--滞纳天数
						cast(h3.VALUE as NUMERIC (20, 4)) value,--滞纳金比率
						--若该条欠费为最早一条欠费则欠费金额减去账户余额后计算滞纳金，否则直接计算滞纳金
						--欠费金额*滞纳天数*滞纳金比例=滞纳金
						case when  h1.f_oughtamount<6 then	0 else 				
						CAST (
							 ROUND({ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(h2.oughtfee, h1.f_oughtfee) * (
								CASE WHEN 
								{ entity.findDialect() == $SqlServer$: $DATEDIFF(dd,isnull(h1.f_end_date, getdate()),getdate())$,
						$trunc(sysdate-{ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(h1.f_end_date, sysdate))$}
								< 0 
									THEN 0 ELSE 
									{ entity.findDialect() == $SqlServer$: $DATEDIFF(dd,isnull(h1.f_end_date, getdate()),getdate())$,
						$trunc(sysdate-{ entity.findDialect() == $SqlServer$: $isnull$,$NVL$}(h1.f_end_date, sysdate))$}
									END
								) * cast(h3.VALUE as NUMERIC (20, 4)),2) 
							 AS NUMERIC (20, 2)) end zhinajin 
					FROM
					({${sql.call($VHandPlan$,{})}$}) h1
					LEFT JOIN (
						--每一用户最早一条欠费记录减去账户余额
						SELECT
							n1.id,
							n2.f_balance,
							(n1.f_oughtfee -n2.f_balance) oughtfee
						FROM
							(
								SELECT * FROM
									({${sql.call($VHandPlan$,{})}$}) m1
								WHERE
									EXISTS (
										SELECT *
										FROM
											(
												SELECT MIN (id) id FROM ({${sql.call($VHandPlan$,{})}$}) xxh
												WHERE f_whether_pay = '否' AND f_meter_state = '已抄表'
												GROUP BY f_userinfo_id
											) m2
										WHERE
											m1.id = m2.id
									)
							) n1
						LEFT JOIN t_userinfo n2 ON n1.f_userinfo_id = n2.f_userinfo_id
					) h2 ON h1.id = h2.id
					LEFT JOIN t_singlevalue h3 ON (
						CASE h1.f_user_type
						WHEN '民用' THEN
							'民用违约金'
						ELSE
							'非民用违约金'
						END
					) = h3.name
					WHERE
						h1.f_whether_pay = '否'
					AND h1.f_meter_state = '已抄表'
				) hand
		) u2 ON u1.f_userinfo_id = u2.f_userinfo_id

	) ss
WHERE f_hand_date!='' and qianfei>0 and {condition}
order by f_hand_date,f_userinfo_id