select * from (
                select
                  u.*,
                  address.f_slice_area as f_zones,
                  address.f_address,
                  address.f_street,
                  address.f_residential_area,
                  address.f_building,
                  address.f_unit,
                  address.f_floor,
                  address.f_room,
                  info.f_userinfo_code,
                  info.f_user_name,
                  info.f_user_phone,
                  info.f_user_state,
                  info.f_idnumber idnumber,
                  info.f_balance,
                  gb.f_meter_brand,
                  gb.f_manufacturers,
                  gm.f_meter_style,
                  sp.f_price_type,
                  sp.f_price_name,
                  case when tcon.f_main_userfilesid = u.f_userfiles_id then 1 else 0 end ismainuserfiles
                from
                  t_userfiles u with(nolock)
                    left join t_user_address address with(nolock)
                              on u.f_useraddress_id = address.id
                    left join t_userinfo info with(nolock)
                              on u.f_userinfo_id = info.f_userinfo_id
                    left join t_gasbrand gb with(nolock)
                              on u.f_gasbrand_id = gb.id
                    left join t_gasmodel gm with(nolock)
                              on u.f_gasmodel_id = gm.id
                    left join t_stairprice sp with(nolock)
                              on u.f_price_id = sp.f_price_id and u.f_filialeid = sp.f_filialeid and sp.f_state = '有效' and getdate()>=f_perform_date and getdate()<= sp.f_end_date
                left join t_concentrator tcon with(nolock)
                    on tcon.id = u.f_concentrator_id
) t
where {condition} and f_table_state in ('正常', '待开通')
order by f_user_id,f_table_state desc
