select * from (
  SELECT
	  i.id,
      u1.f_userinfo_id,				                            --用户id
	  u1.f_userfiles_id,										--气表id
      u2.f_userinfo_code,				                        --用户编号
	  u2.f_user_name,					                        --用户名
      u3.f_address,						                        --用户地址
	  u1.f_user_type,                                           --用户类型
      u1.f_gasproperties,                                       --用气性质
      i.f_meternumber,				                            --表号
	  u4.f_meter_brand,                                         --气表品牌
	  u1.f_filialeid,											--组织id（查询用）
	  u1.f_orgname,											    --组织名称	(显示用)
	  i.f_send_date,
	  i.f_callback_date,
	  i.f_instruct_title,
      i.f_instruct_type,         --指令类型
      i.f_instruct_state,        --指令状态
      i.f_instruct_date,         --指令时间
	  i.f_receive_state,          --执行结果
      i.f_instruct_content,      --指令内容(暂时先查出来，后面需要点击列表，右侧做指令内容解析展示)
      isnull(recordinfo.type,'') f_operate_type,
      isnull(recordinfo.f_operator,'') f_operator,
      recordinfo.f_state,
      isnull(recordinfo.f_operate_date,null)  f_operate_date,
      isnull(recordinfo.note,'') note
  FROM t_instruct i with(nolock)
	left join t_userfiles u1 with(nolock) on i.f_userfiles_id=u1.f_userfiles_id
	left join t_userinfo u2 with(nolock) ON u1.f_userinfo_id= u2.f_userinfo_id
	left join t_user_address u3 with(nolock) on u1.f_useraddress_id=u3.id
	left join t_gasbrand u4 with(nolock) ON u1.f_gasbrand_id= u4.id
    left join (
      select
          id,
	      f_state,
          f_user_id,
          f_pregas as gas,
          f_preamount as fee,
          f_collection,
          f_type as type,
          f_operator,
          case when f_operator='悦生活' and f_write_date is not null then
          f_write_date
          else
          f_operate_date end f_operate_date,
          '应收:'+convert(varchar(100),f_preamount)+',实收:'+convert(varchar(100),f_collection) as note,
          f_write_card
      from t_sellinggas where f_orgid={f_orgid} and {f_start_date==$$:$ 1=1 $,$f_operate_date>={f_start_date}$} and f_state != '无效'
      and {f_end_date==$$:$ 1=1 $,$f_operate_date<={f_end_date}$}
      union all
      select
          id,
	      f_state,
          f_user_id,
          isnull(f_pregas, 0) as gas,
          isnull(f_preamount, 0) as fee,
          0 as f_collection,
          f_type as type,
          f_operator,
          f_operate_date as f_operate_date,
          '补费金额:'+convert(varchar(50),f_preamount) as note,
          f_write_card
      from t_fillgas where f_orgid={f_orgid} and {f_start_date==$$:$ 1=1 $,$f_operate_date>={f_start_date}$} and f_state != '无效'
	    and {f_end_date==$$:$ 1=1 $,$f_operate_date<={f_end_date}$}
      union all
      select
          id,
          f_state,
          f_user_id,
          0 as gas,
          0 as fee,
          f_changemeter_fee as f_collection,
          f_type as type,
          f_operator,
          f_operate_date as f_operate_date,
          '旧表号:'+f_meternumber_old+',新表号:'+f_meternumber+',补气金额:'+convert(varchar(100),f_remanent_money)  as note,
          '' f_write_card
      from t_changetables where f_orgid={f_orgid} and {f_start_date==$$:$ 1=1 $,$f_operate_date>={f_start_date}$} and f_state != '无效'
      and {f_end_date==$$:$ 1=1 $,$f_operate_date<={f_end_date}$}
	    union all
	    select
	    id,
        '有效' f_state,
	    '' f_user_id,
        0 as gas,
        0 as fee,
        0 f_collection,
        f_change_type+'调价' type,
        f_operator,
        f_operate_date as f_operate_date,
          '生效时间:'+convert(varchar(30),f_perform_date,21)+' 新气价:'+p1.f_price_value
          +',原气价:'+p2.f_price_value 	as note,
        '' f_write_card
      from t_pricechange tp
      left join (
          select sp.id priceid,
            f_price_name,
      sp.f_price_name+'('+sp.f_price_type+')'+':'+cast((select cast(f_price as varchar)+'|' from t_detailprice where f_stairprice_id=sp.id group by f_price for xml path('')) as varchar) f_price_value
          from t_stairprice sp
      ) p1 on p1.priceid = tp.f_newprice_id
      left join (
          select
	        sp.id priceid,
            f_price_name,
      sp.f_price_name+'('+sp.f_price_type+')'+':'+cast((select cast(f_price as varchar)+'|' from t_detailprice where f_stairprice_id=sp.id group by f_price for xml path('')) as varchar) f_price_value
          from t_stairprice sp
      ) p2 on p2.priceid = tp.f_oldprice_id
      where  {f_start_date==$$:$ 1=1 $,$f_operate_date>={f_start_date}$}
      and {f_end_date==$$:$ 1=1 $,$f_operate_date<={f_end_date}$}
    ) recordinfo on i.f_data_id=recordinfo.id
) tt
where  {condition}
order by id DESC
