/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EncodeUtil {
    public static String stringToUnicode(String s) {
        try {
            StringBuffer out = new StringBuffer("");
            byte[] bytes = s.getBytes("unicode");
            for (int i = 0; i < bytes.length - 1; i += 2) {
                out.append("\\u");
                String str = Integer.toHexString(bytes[i + 1] & 0xFF);
                for (int j = str.length(); j < 2; ++j) {
                    out.append("0");
                }
                String str1 = Integer.toHexString(bytes[i] & 0xFF);
                out.append(str1);
                out.append(str);
            }
            return out.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String unicodeToString(String str) {
        Pattern pattern = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            String group = matcher.group(2);
            char ch = (char)Integer.parseInt(group, 16);
            String group1 = matcher.group(1);
            str = str.replace(group1, ch + "");
        }
        return str;
    }

    public static String convertStringToUTF8(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c >= '\u0000' && c <= '\u00ff') {
                    sb.append(c);
                    continue;
                }
                byte[] b = Character.toString(c).getBytes("utf-8");
                for (int j = 0; j < b.length; ++j) {
                    int k = b[j];
                    k = k < 0 ? k + 256 : k;
                    sb.append(Integer.toHexString(k).toUpperCase());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String convertUTF8ToString(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        try {
            s = s.toUpperCase();
            int total = s.length() / 2;
            int pos = 0;
            byte[] buffer = new byte[total];
            for (int i = 0; i < total; ++i) {
                int start = i * 2;
                buffer[i] = (byte)Integer.parseInt(s.substring(start, start + 2), 16);
                ++pos;
            }
            return new String(buffer, 0, pos, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return s;
        }
    }
}

