/*
 * Decompiled with CFR 0.152.
 */
package com.aote.redis;

import com.aote.redis.NewRedisUtil;
import com.aote.rs.SqlService;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CacheUtil {
    private static final Logger LOGGER = Logger.getLogger(CacheUtil.class);
    @Autowired
    private SqlService sqlService;

    public JSONArray getAndCache(String sqlName, JSONObject params, Integer pageSize) {
        return this.getAndCache(sqlName, params, pageSize, 21600);
    }

    public JSONArray getAndCache(String sqlName, JSONObject params, Integer pageSize, Integer time) {
        TreeMap treeMap = new TreeMap(params.toMap());
        String treeString = treeMap.toString();
        String keyName = sqlName + "@" + treeString;
        LOGGER.info((Object)("\u83b7\u53d6\u5e76\u7f13\u5b58\u7684SQL\u540d\u79f0\uff1a" + sqlName + "\uff0c\u53c2\u6570\uff1a" + treeString + "\uff0c\u7f13\u5b58\u65f6\u95f4\uff1a" + time + "\u79d2"));
        NewRedisUtil redisUtil = NewRedisUtil.getInstance();
        Object data = redisUtil.get(keyName);
        if (data != null) {
            LOGGER.info((Object)(sqlName + "\u83b7\u53d6\u7f13\u5b58\u6570\u636e"));
            return new JSONArray(redisUtil.get(keyName).toString());
        }
        AtomicReference result = new AtomicReference();
        redisUtil.lock(keyName + "_LOCK", () -> {
            Object cacheData = redisUtil.get(keyName);
            if (cacheData != null) {
                result.set(new JSONArray(cacheData.toString()));
                return;
            }
            try {
                LOGGER.info((Object)(sqlName + "\u65e0\u7f13\u5b58\uff0c\u8fdb\u884c\u7f13\u5b58"));
                int realPageSize = pageSize;
                if (realPageSize < 1) {
                    realPageSize = 9999999;
                }
                result.set(new JSONArray(this.sqlService.txExecute(sqlName, 1, realPageSize, new JSONObject().put("data", (Object)params).toString())));
                redisUtil.set(keyName, result.toString(), time);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return (JSONArray)result.get();
    }
}

