select
 *
from(
	select
		u.f_user_name,	    --用户姓名
		a.f_address,	    --用户地址
		u.f_user_state,	    --用户状态
		u.f_userinfo_code,  --用户统一编码
	    isnull(u.f_olduserinfo_code,'') f_olduserinfo_code,
		u.f_userinfo_id,
		u.f_user_phone,	    --用户电话
		u.f_idnumber,    --证件号码
		u.f_people_num,
		u.f_credentials,    --证件类型
		isnull(u.f_balance,0) f_balance,        --账户余额
		uf.f_user_type,	    --用户类型
	    uf.f_card_id,       --卡号
		uf.f_gasproperties,	--用气性质
		uf.f_position,      --安装位置
		uf.f_table_state,	--气表状态
		uf.f_balance_gas,     --剩余气量
		uf.f_balance_amount,  --剩余金额
		uf.f_meternumber,	  --表钢号
		uf.f_user_id,         --表编号
		uf.f_aroundmeter,     -- 左右表
		uf.f_userfiles_id,
	    uf.f_concentrator_id,
	    uf.f_filialeid,
		isnull(uf.f_total_gas,0) f_total_gas,  --累计气量
		isnull(uf.f_total_fee,0) f_total_fee,  --累计气量
		isnull(uf.f_history_gas,0) f_history_gas,  --累计气量
		isnull(uf.f_history_fee,0) f_history_fee,  --累计气量
		uf.f_open_date,	      --开户日期
		uf.f_initial_base,	  --初始底数
		uf.f_meter_base,	  --系统底数/最后上报底
		uf.f_flowmeternumber,  ---流量计表号
		uf.f_meteread_date,   -- 最后上报时间(IOT)
		uf.f_hand_date, -- 最后抄表时间(IOT)
		uf.f_meteread_number, -- 累计上报次数(IOT)
		uf.f_total_usegas_amount, -- 累计用气金额(IOT)
		--case when mr1.f_valveState = 0 then '关阀' else '开阀' end f_valveState,  -- 阀门状态
    mr1.f_valveState,
		gb.f_meter_brand,	  --气表品牌
		gb.f_meter_type,     --气表类型
    gb.f_alias,           --别名
    gb.f_collection_type, --扣费类型

		gm.f_meter_style,	  --气表型号
		sp.f_price_type,	  --气价类型
		sp.f_price_name,	  --气价名称
		detailprice.f_detailprice,  --价格明细
        isnull(uf.f_deduction_gas,0) f_deduction_gas,
	    uf.f_comments  f_userfiles_comments,
	    u.f_comments f_userinfo_comments
	from t_userfiles uf with(nolock)
		left join t_userinfo u with(nolock) on uf.f_userinfo_id=u.f_userinfo_id
		left join t_gasbrand gb with(nolock) on uf.f_gasbrand_id = gb.id
		left join t_gasmodel gm with(nolock) on uf.f_gasmodel_id = gm.id
		LEFT JOIN t_user_address a with(nolock) ON (a.f_userinfo_id = u.f_userinfo_id)
		left join (
		  select f_userfiles_id, max(id) as maxid from t_meteread with(nolock) group by f_userfiles_id
		) mr on uf.f_userfiles_id = mr.f_userfiles_id
		left join t_meteread mr1 with(nolock) on mr.maxid = mr1.id
		left join (select * from t_stairprice with(nolock) where f_state='有效' and ( (getdate()>=f_perform_date and getdate()<=f_end_date) or (getdate()<=f_perform_date) ))	sp on uf.f_price_id=sp.f_price_id
    LEFT JOIN (
    select
      f_stairprice_id,
      (select cast(f_price as varchar) + '|' from t_detailprice with(nolock) where f_stairprice_id=d.f_stairprice_id for xml path(''))  f_detailprice
    from t_detailprice d with(nolock) group by f_stairprice_id
  ) detailprice ON sp.id = detailprice.f_stairprice_id
) u
where {condition} and f_table_state != '换表' and f_table_state != '无效'
