SELECT
    b.f_plan_name,
    b.f_issue_time,
    c.max_f_last_check_date,
    d.min_f_last_check_date,
    a.f_plan_num,
    max ( f_weijian ) f_weijian,
    max ( f_yijian ) f_yijian,
    max ( f_ruhu ) f_ruhu,
    max ( f_buyu ) f_buyu,
    max ( f_jujian ) f_jujian,
    CAST (
            CONVERT (
                    DECIMAL ( 18, 2 ),
                    CASE

                        WHEN a.f_plan_num = 0 THEN
                            0.00 ELSE max ( f_yijian ) / ( a.f_plan_num + 0.00 ) * 100.00
                        END
                ) AS VARCHAR
        ) + '%' f_check_bv,
    CAST (
            CONVERT (
                    DECIMAL ( 18, 2 ),
                    CASE

                        WHEN a.f_plan_num = 0 THEN
                            0.00 ELSE max ( f_ruhu ) / ( a.f_plan_num + 0.00 ) * 100.00
                        END
                ) AS VARCHAR
        ) + '%' f_ruhu_bv
FROM
        ( SELECT id FROM t_area WHERE { condition.condition1 } ) area
        LEFT JOIN t_user_address tud ON area.id = tud.f_residential_area_id
        LEFT JOIN (
        SELECT
            f_plan_id,
            count(0) as f_plan_num,
            sum(CASE
                WHEN f_state= '未检' THEN
                    1 ELSE 0
                END) f_weijian,
            sum(CASE

                WHEN f_state= '已检' THEN
                    1 ELSE 0
                END) f_yijian,
            sum(CASE
                WHEN f_state= '已检' and f_last_check_state = '入户' THEN
                    1 ELSE 0
                END) f_ruhu,
            sum(CASE

                WHEN f_state= '已检' and f_last_check_state = '到访不遇' THEN
                    1 ELSE 0
                END) f_buyu,
            sum(CASE
                WHEN f_state= '已检' and f_last_check_state = '拒检' THEN
                    1 ELSE 0
                END) f_jujian
        FROM
            t_check_plan_item cpi group by f_plan_id
    ) a ON a.f_plan_id = tud.f_plan_id
        LEFT JOIN t_check_plan b ON a.f_plan_id = b.id
        LEFT JOIN (
        SELECT
            tcpi.f_plan_id,
            MAX ( tcpi.f_last_check_date ) AS max_f_last_check_date
        FROM
            t_check_plan_item tcpi
                LEFT JOIN (
                SELECT
                    tcp.id,
                    a.num1,
                    b.num2
                FROM
                    t_check_plan tcp
                        LEFT JOIN ( SELECT f_plan_id, COUNT ( 0 ) num1 FROM t_check_plan_item GROUP BY f_plan_id ) a ON tcp.id = a.f_plan_id
                        LEFT JOIN ( SELECT f_plan_id, COUNT ( 0 ) num2 FROM t_check_plan_item WHERE f_state = '已检' GROUP BY f_plan_id ) b ON tcp.id = b.f_plan_id
            ) a ON tcpi.f_plan_id = a.id
        WHERE
                a.num1 = a.num2
        GROUP BY
            tcpi.f_plan_id
    ) c ON c.f_plan_id = b.id
        LEFT JOIN ( SELECT f_plan_id, MIN ( f_last_check_date ) min_f_last_check_date FROM t_check_plan_item where f_state = '已检' GROUP BY f_plan_id ) d ON b.id = d.f_plan_id
WHERE
    { condition.condition2 }
GROUP BY
    f_plan_name,
    max_f_last_check_date,
    min_f_last_check_date,
    f_issue_time,f_plan_num
