SELECT
    *,
    CASE
        WHEN dw_value = '年' THEN
            DATEDIFF(
                DAY,
                    GETDATE( ),
                    ( DATEADD( YEAR, CAST ( zq_value AS INT ), first_check_date ) )
                ) ELSE DATEDIFF(
        DAY,
            GETDATE( ),
            ( DATEADD( MONTH, CAST ( zq_value AS INT ), first_check_date ) )
        )
        END AS difference_day
FROM
    (
        SELECT
            ta.f_residential_area,
            max(tcp.f_plan_name) as f_plan_name,
            max(tud2.area_num) AS area_num,
            tcpi2.plan_num AS plan_num,
            tcp.f_issue_time,
            MIN ( tcpi.f_last_check_date ) AS first_check_date,
            zq.value AS zq_value,
            dw.value AS dw_value,
            a.max_f_last_check_date AS f_use_end_time
        FROM
            t_area ta
                LEFT JOIN (select COUNt(0) as area_num,tua.f_residential_area_id from t_user_address tua left join t_userinfo ti on tua.f_userinfo_id = ti.f_userinfo_id where  ti.f_user_state != '销户' GROUP BY tua.f_residential_area_id) tud2 ON ta.id = tud2.f_residential_area_id
                LEFT JOIN t_user_address tud ON ta.id = tud.f_residential_area_id
                LEFT JOIN (select COUNt(0) as plan_num,f_plan_id from t_check_plan_item GROUP BY f_plan_id) tcpi2 ON tcpi2.f_plan_id = ta.f_plan_id
                LEFT JOIN t_check_plan tcp ON ta.f_plan_id = tcp.id
                LEFT JOIN (
                SELECT
                    tcpi.f_plan_id,
                    MAX ( tcpi.f_last_check_date ) AS max_f_last_check_date
                FROM
                    t_check_plan_item tcpi
                        LEFT JOIN (
                        SELECT
                            tcp.id,
                            a.num1,
                            b.num2
                        FROM
                            t_check_plan tcp
                                LEFT JOIN ( SELECT f_plan_id, COUNT ( 0 ) num1 FROM t_check_plan_item GROUP BY f_plan_id ) a ON tcp.id = a.f_plan_id
                                LEFT JOIN ( SELECT f_plan_id, COUNT ( 0 ) num2 FROM t_check_plan_item WHERE f_state = '已检' GROUP BY f_plan_id ) b ON tcp.id = b.f_plan_id
                    ) a ON tcpi.f_plan_id = a.id
                WHERE
                        a.num1 = a.num2
                GROUP BY
                    tcpi.f_plan_id
            ) a ON a.f_plan_id = tcp.id
                LEFT JOIN t_check_plan_item tcpi ON tud.f_plan_id = tcpi.f_plan_id
                LEFT JOIN t_organization org ON org.id = tud.f_filialeid
                LEFT JOIN t_singlevalue zq ON zq.name = org.name + '安检执行周期'
                LEFT JOIN t_singlevalue dw ON dw.name = org.name + '安检周期单位'
        WHERE
            {condition}
        GROUP BY
            ta.f_residential_area,
            tcp.f_plan_name,
            tcp.f_issue_time,
            zq.value,
            max_f_last_check_date,
            dw.value,
            tcpi2.plan_num
    ) a
ORDER BY
    f_residential_area desc
