 select *   from  (
    SELECT
        isnull( tcp.f_checker, tt.f_checker_name ) AS f_checker,
        isnull( tcp.f_checker_id, tt.f_checker_id ) AS f_checker_id,
        CASE
            WHEN tcpi.f_state = '未检'
                OR ( tcpi.f_state = '已检' AND tcpi.F_LAST_CHECK_STATE != '入户' ) THEN
                1 ELSE 0
            END AS wrj,
        CASE
            WHEN tcpi.f_state = '已检'
                AND tcpi.F_LAST_CHECK_STATE = '入户' THEN
                1 ELSE 0
            END AS yrj,
        ruhu,
        daofang,
        jujian
    FROM
        (
            SELECT
                *
            FROM
                t_check_plan
            WHERE
                f_filialeid IN { f_filialeids }
        ) tcp
            LEFT JOIN ( SELECT * FROM t_check_plan_item WHERE f_filialeid IN { f_filialeids } ) tcpi ON tcp.id = tcpi.f_plan_id
            LEFT JOIN (
            SELECT
                a.*,
                CASE
                    WHEN f_entry_status = '入户'
                        THEN
                        1 ELSE 0
                    END AS ruhu,
                CASE
                    WHEN f_entry_status = '到访不遇'
                        THEN
                        1 ELSE 0
                    END AS daofang,
                CASE
                    WHEN f_entry_status = '拒检'
                        THEN
                        1 ELSE 0
                    END AS jujian
            FROM
                t_check_paper a
                    INNER JOIN ( SELECT f_check_item_id, max( f_upload_date ) upload_time FROM t_check_paper GROUP BY f_check_item_id ) b ON a.f_check_item_id = b.f_check_item_id
                    AND b.upload_time = a.f_upload_date
            WHERE
                f_filialeid IN { f_filialeids } AND
                 F_NO_CHECKPLAN = '有计划安检'
                 { f_start_time == $$ : $$, $ AND f_offsite_time >= '{f_start_time} 00:00:00' $ } { f_end_time == $$ : $$, $ AND f_offsite_time <= '{f_end_time} 23:59:59' $ }
        ) tt ON tt.f_check_item_id = tcpi.id

) paper
 WHERE
    1 = 1
     AND { condition }
