SELECT
    tcp.id AS check_paper_id,
    tcp.f_userinfo_code,
    tcp.f_user_name,
    tcp.f_user_phone,
    tcp.f_residential_area,
    tcp.f_address,
    tcp.f_checker_name,
    tcp.f_offsite_time,
    tcp.f_filialeid,
    tpd.f_device_type,
    tdi.id AS device_id,
    tdi.f_item_name,
    tdi.f_path,
    tdi.f_p1_path,
    tdi.f_p2_path,
    tdi.f_p3_path,
    tdi.f_deal_dispose,
    tcp.f_upload_date,
    tu.f_userinfo_id AS f_userinfo_id,
    (case when (t.f_orderstate is null or t.f_orderstate = '预约失败') then '正在整改'
          when t.f_orderstate = '待处理' then '正在审核'
          when t.f_orderstate = '预约成功' then '整改完成'
        end) f_order_state,
    t.f_suggest
FROM t_check_paper tcp
         LEFT JOIN t_userinfo tu ON tu.f_userinfo_code = tcp.f_userinfo_code
         LEFT JOIN t_paper_devices tpd ON tcp.id = tpd.f_paper_id
         LEFT JOIN t_devices_items tdi ON tpd.id = tdi.f_device_id
         LEFT JOIN (
    SELECT
        oc.f_orderstate f_orderstate,
        oc.f_defect_id f_defect_id,
        oc.f_suggest f_suggest,
        ROW_NUMBER() OVER (PARTITION BY oc.f_defect_id ORDER BY oc.f_submit_time DESC) AS row_num
    FROM t_order_center oc
             INNER JOIN t_devices_items di ON di.id = oc.f_defect_id
) t ON tdi.id = t.f_defect_id AND t.row_num = 1
WHERE tdi.f_is_defect = 'true'
  AND (tdi.f_deal_dispose in ('自行处理', '自行整改') OR tdi.f_user_changes = '是')
  AND {condition}
ORDER BY
    f_upload_date DESC


