SELECT
    *,
    cast(
            CONVERT ( DECIMAL ( 18, 2 ), CASE WHEN area_num = 0 THEN 0.00 ELSE rh_num /( area_num + 0.00 )* 100.00 END ) AS VARCHAR
        )+ '%' AS rh_bv,
    cast(
            CONVERT (
                    DECIMAL ( 18, 2 ),
                    CASE

                        WHEN area_num = 0 THEN
                            0.00 ELSE ( rh_num + dfby_num + jj_num + jgjc_num )/(
                            area_num + 0.00
                        )* 100.00
                        END
                ) AS VARCHAR
        )+ '%' AS aj_bv
FROM
    (
        SELECT
            ui.f_user_region,
            ta.f_residential_area,
            sum( CASE WHEN f_no_checkplan = '有计划安检' AND f_entry_status = '入户' THEN 1 ELSE 0 END ) AS yjh_rh_num,
            sum( CASE WHEN f_no_checkplan = '无计划安检' AND f_entry_status = '入户' THEN 1 ELSE 0 END ) AS wjh_rh_num,
            sum( CASE WHEN f_no_checkplan = '有计划安检' AND f_entry_status = '到访不遇' THEN 1 ELSE 0 END ) AS yjh_dfby_num,
            sum( CASE WHEN f_no_checkplan = '无计划安检' AND f_entry_status = '到访不遇' THEN 1 ELSE 0 END ) AS wjh_dfby_num,
            sum( CASE WHEN f_no_checkplan = '有计划安检' AND f_entry_status = '拒检' THEN 1 ELSE 0 END ) AS yjh_jj_num,
            sum( CASE WHEN f_no_checkplan = '无计划安检' AND f_entry_status = '拒检' THEN 1 ELSE 0 END ) AS wjh_jj_num,
            sum( CASE WHEN f_no_checkplan = '有计划安检' AND f_entry_status = '激光检测' THEN 1 ELSE 0 END ) AS yjh_jgjc_num,
            sum( CASE WHEN f_no_checkplan = '无计划安检' AND f_entry_status = '激光检测' THEN 1 ELSE 0 END ) AS wjh_jgjc_num,
            sum( CASE WHEN f_entry_status = '入户' THEN 1 ELSE 0 END ) AS rh_num,
            sum( CASE WHEN f_entry_status = '到访不遇' THEN 1 ELSE 0 END ) AS dfby_num,
            sum( CASE WHEN f_entry_status = '拒检' THEN 1 ELSE 0 END ) AS jj_num,
            sum( CASE WHEN f_entry_status = '激光检测' THEN 1 ELSE 0 END ) AS jgjc_num,
            count( tu.id ) AS area_num
        FROM
            t_area ta
                LEFT JOIN t_user_address tu ON ta.id = tu.f_residential_area_id
                LEFT JOIN t_userinfo ui ON ui.f_userinfo_id = tu.f_userinfo_id
                LEFT JOIN (SELECT *,row_number() over ( PARTITION BY f_userinfoid ORDER BY f_upload_date DESC ) rn FROM t_check_paper WITH ( nolock )) cp ON cp.f_userinfoid = ui.f_userinfo_id AND cp.rn = 1
        where { condition }
        GROUP BY
            ui.f_user_region,
            ta.f_residential_area
    ) a
ORDER BY
    area_num DESC
