SELECT
    tb.*,
    o.name f_subcompany
FROM
    (
        SELECT
            f_filialeid,
            SUM ( A ) A,
            SUM ( B ) B,
            SUM ( C ) C,
            SUM ( AC ) AC,
            SUM ( B ) BC,
            SUM ( CC ) CC
        FROM
            (
                SELECT
                    f_filialeid,
                    isnull( A, 0 ) A,
                    isnull( B, 0 ) B,
                    isnull( C, 0 ) C,
                    0 AC,
                    0 BC,
                    0 CC
                FROM
                    (
                        SELECT
                            tcp.f_filialeid,
                            LEFT ( f_defect_level, 1 ) name,
                            COUNT ( 1 )
                            VALUE

                        FROM
                            t_check_paper tcp,
                            t_check_paper_defect tpd
                        WHERE
                            tpd.f_paper_id = tcp.id
                            { orgid != $$ :
                            $
                          AND f_filialeid IN { orgid } $,
                            $ $
                            }
                            { f_safecheck_type != $$ :
                            $
                          AND tcp.f_safecheck_type = '{ f_safecheck_type }' $,
                            $ $
                            }
                          AND tcp.f_offsite_time >= '{startDate}'
                          AND tcp.f_offsite_time <= '{endDate}' { plan_type == $ FALSE $ :
                            $
                          AND tcp.f_safe_type IS NULL $,
                            plan_type == $ TRUE $ :
                            $
                          AND tcp.f_safe_type = '{plan_type}' $,
                            plan_type == $$ :
                            $
                          AND 1 = 1 $,
                            $$
                            }
                        GROUP BY
                            f_filialeid,
                            LEFT ( f_defect_level, 1 )) AS P PIVOT ( SUM ( VALUE ) FOR p.name IN ( [A], [B], [C] ) ) AS T UNION ALL
                SELECT
                    f_filialeid,
                    0 A,
                    0 B,
                    0 C,
                    isnull( A, 0 ) AC,
                    isnull( B, 0 ) BC,
                    isnull( C, 0 ) CC
                FROM
                    (
                    SELECT
                    tcp.f_filialeid,
                    LEFT ( f_defect_level, 1 ) name,
                    SUM ( CASE WHEN tpd.f_ratification  = '已处理' THEN 1 ELSE 0 END ) change
                    FROM
                    t_check_paper tcp,
                    t_check_paper_defect tpd
                    WHERE
                    tpd.f_paper_id = tcp.id
                    { orgid != $$ :
                    $
                    AND f_filialeid IN { orgid } $,
                    $ $
                    }
                    { f_safecheck_type != $$ :
                    $
                    AND tcp.f_safecheck_type = '{ f_safecheck_type }' $,
                    $ $
                    }
                    AND tcp.f_offsite_time >= '{startDate}'
                    AND tcp.f_offsite_time <= '{endDate}' { plan_type == $ FALSE $ :
                    $
                    AND tcp.f_safe_type IS NULL $,
                    plan_type == $ TRUE $ :
                    $
                    AND tcp.f_safe_type = '{plan_type}' $,
                    plan_type == $$ :
                    $
                    AND 1 = 1 $,
                    $$
                    }
                    GROUP BY
                    f_filialeid,
                    LEFT ( f_defect_level, 1 )) AS P PIVOT ( SUM ( change ) FOR p.name IN ( [A], [B], [C] ) ) AS T
            ) xxx
        GROUP BY
            f_filialeid
    ) tb
        LEFT JOIN t_organization o ON o.id= tb.f_filialeid
ORDER BY
    o.name
