SELECT
    f_entry_status name,
    COUNT ( DISTINCT u2.f_userinfoid )
    VALUE

FROM
    t_check_plan_item u1
    LEFT JOIN (
    SELECT
    *
    FROM
    (
    SELECT
    *,
    ROW_NUMBER () OVER ( partition BY f_userinfoid ORDER BY f_upload_date DESC ) AS lastcheck
    FROM
    (
    SELECT
    f_userinfoid,
    f_upload_date,
    f_check_item_id,
    f_entry_status,
    f_safe_type,
    f_offsite_time
    FROM
    t_check_paper
    WHERE
    f_check_type = '民用'
    AND f_offsite_time >= '{startDate} 00:00:00'
    AND f_offsite_time <= '{endDate} 23:59:59'
    ) tp
    ) t
    WHERE
    lastcheck = 1
    ) u2 ON u1.id= u2.f_check_item_id
    LEFT JOIN t_check_plan u3 ON u3.id= u1.f_plan_id
    LEFT JOIN t_userinfo tu ON tu.f_userinfo_id = u1.f_userinfoid
WHERE
    u1.f_user_type = '民用'
    { f_orgstr != $$ :
    $
  AND u1.f_filialeid IN { f_orgstr } $,
    $ $
    }
    { f_safecheck_type != $$ :
    $
    AND u1.f_safecheck_type = '{ f_safecheck_type }' $,
    $ $
    }
  AND ( tu.f_user_state= '正常' OR tu.f_user_state= '停用' ) { plan_type == $ FALSE $ :
    $
  AND tu.f_open_date < DATENAME( YEAR, '{startDate}' ) + '-01-01 00:00:00' $,
    plan_type == $ TRUE $ :
    $
  AND tu.f_open_date > DATENAME( YEAR, '{startDate}' ) + '-01-01 00:00:00' $,
    plan_type == $$ :
    $
  AND 1 = 1 $,
    $$
    }
GROUP BY
    f_entry_status
