SELECT
    isnull(tcp2.checker,'未定义') as checker,
    isnull(COUNT(0),0) AS data1,
    isnull(SUM(CASE WHEN tcpi.f_state = '未检' and tcpi.f_last_check_state is null THEN 1 ELSE 0 END),0) AS data2,
    isnull(SUM(CASE WHEN tcpi.f_upload_state='已传' and tcpi.f_last_check_state in ('入户') OR (tcpi.f_last_check_state = '到访不遇' and tcpi.f_check_version >= 3) THEN 1 ELSE 0 END),0) AS data3,
    isnull(SUM(CASE WHEN tcpi.f_upload_state='已传' and tcpi.f_last_check_state = '入户' THEN 1 ELSE 0 END),0) AS data4,
    isnull(SUM(CASE WHEN tcpi.f_upload_state='已传' and tcpi.f_last_check_state = '到访不遇' and tcpi.f_check_version >= 3 THEN 1 ELSE 0 END),0) AS data5,
    isnull(SUM(CASE WHEN tcpi.f_upload_state='已传' and tcpi.f_last_check_state = '拒检' THEN 1 ELSE 0 END),0) AS data6,
    case when COUNT(0) = 0 then '0.00%' else
            CONVERT(varchar,CONVERT(decimal(10, 2), ((SUM(CASE WHEN tcpi.f_upload_state='已传' and tcpi.f_last_check_state = '入户' OR tcpi.f_check_version >= 3 THEN 1 ELSE 0 END) * 100.0) / NULLIF(COUNT(*), 0))))+ '%' end AS data7,
    tcp2.data8 AS data8,
    isnull(SUM(CASE WHEN tcpi.f_upload_state='已传' and tcpi.f_last_check_state = '入户' THEN 1 ELSE 0 END),0) + tcp2.data8 as data9
FROM
    t_check_plan_item tcpi
        LEFT JOIN t_check_plan tcp ON tcpi.f_plan_id = tcp.id
        left join (SELECT f_checker_name as checker,count(0) AS data8 FROM t_check_paper WHERE f_checker_name IS NOT NULL and {condition.condition2} and f_no_checkplan='无计划安检' GROUP BY f_checker_name) tcp2 on tcp.f_checker = tcp2.checker
WHERE
    tcp.f_checker IS NOT NULL and {condition.condition1}
GROUP BY
    tcp2.checker,tcp2.data8
order by tcp2.checker
