SELECT
    tcp.f_residential_area,
    sum( 1 ) as yhhs,
    sum( case when b.wcl != b.a and b.yclyh != b.a then 1 else 0 end )  as clzyh,
    sum( 1 ) - sum( case when b.wcl != b.a and b.yclyh != b.a then 1 else 0 end ) - sum( case when b.yclyh = b.a then 1 else 0 end ) as wcl,
    sum( case when b.yclyh = b.a then 1 else 0 end )  as yclyh
FROM
    t_check_paper tcp
        LEFT JOIN (
        SELECT
            tcp.id,
            count( tdi.id ) AS a,
            sum( CASE WHEN tdi.f_live_dispose='是' or tdi.f_is_repaired in ('已处理') or tdi.f_deal_dispose in ('现场整改') THEN 1 ELSE 0 END ) AS yclyh,
            sum( CASE WHEN tdi.f_deal_dispose in ('未处理','报修','自行处理','自行整改') and f_repaired != '已转维修' THEN 1 ELSE 0 END ) AS wcl,
            sum( CASE WHEN f_repaired = '已转维修' AND tdi.f_is_repaired = '转维修' THEN 1 ELSE 0 END ) AS clzyh
        FROM
            t_check_paper tcp
                LEFT JOIN ( SELECT f_userinfoid, max( f_upload_date ) f_upload_date FROM t_check_paper WHERE f_entry_status = '入户' AND f_defect_content LIKE '%有隐患%' GROUP BY f_userinfoid ) tcp2 ON tcp.f_userinfoid = tcp2.f_userinfoid AND tcp.f_upload_date = tcp2.f_upload_date
                LEFT JOIN t_paper_devices tpd ON tcp.id = tpd.f_paper_id
                LEFT JOIN t_devices_items tdi ON tpd.id = tdi.f_device_id
        WHERE
                1 = 1
          AND f_is_defect = 'true'
        GROUP BY
            tcp.id
    ) b ON tcp.id = b.id
WHERE {condition} and tcp.f_filialeid = {orgid} and f_defect_content like '%有隐患%'
GROUP BY
    tcp.f_residential_area
order BY
    tcp.f_residential_area
