SELECT
        t_temp2.*
--         t23.f_deal_remark
FROM (
	SELECT
		t_temp.*,f_meter_book_num,f_slice_area,tu.f_meternumber,tu.f_gas_date,
		(
			CASE f_defect_count
				WHEN 0
					THEN '无隐患'
				ELSE '有隐患'
			END
		) f_has_defect,
		(
			CASE WHEN f_repair_count=f_defect_count
					THEN '已完成'
				ELSE '未完成'
			END
		) f_is_repair,
		(
			CASE
			    WHEN f_deal_count=f_defect_count THEN '已处理'
			    WHEN f_deal_count = 0 THEN '未处理'
			    ELSE '处理中'
			END
		) f_is_deal
	FROM (
		SELECT
			cp.id,
			cp.f_entry_status,
			cp.f_residential_area,
			cp.f_user_phone,
			cp.f_userinfo_code,
			cp.f_user_name,
			cp.f_onsite_time,
			cp.f_offsite_time,
			cp.f_checker_name,
			cp.f_repaired,
			ua.f_address,
			cp.f_check_plan_id,
			cpl.f_plan_name,
			ui.f_userinfo_id,
			ui.f_filialeid,
			f_defect_content,
            {f_defect_content} defecttext,
            pd1.*
		FROM
			t_check_paper cp
			LEFT JOIN t_check_plan cpl ON cpl.id = cp.f_check_plan_id
			LEFT JOIN t_userinfo ui ON ui.f_userinfo_id = cp.f_userinfoid
			LEFT JOIN t_user_address ua ON ua.f_userinfo_id = cp.f_userinfoid
		    LEFT JOIN (
                            SELECT
                                pd.f_paper_id,
                                ISNULL(
                                        SUM(
                                           CASE di.f_is_defect
                                            WHEN 'true'
                                                THEN 1
                                            ELSE 0
                                        END
                                ),0) f_defect_count,
                                ISNULL(
                                        SUM(
                                           CASE
                                            WHEN di.f_live_dispose='是' or di.f_is_repaired='已处理'
                                                THEN 1
                                            ELSE 0
                                        END
                                ),0) f_repair_count,
                                ISNULL(
                                        SUM(
                                           CASE
                                            WHEN di.f_is_defect='true' AND (di.f_deal_dispose in ('现场整改', '自行处理', '转维修', '报修') OR di.f_is_repaired = '已处理' OR di.f_audit_results = '通过')
                                                THEN 1
                                            ELSE 0
                                        END
                                ),0) f_deal_count,
                                max(f_repairman) f_repairman,
                                ISNULL(
                                        SUM(
                                                CASE
                                                    WHEN di.f_is_defect = 'true' and f_device_type='一级隐患'
                                                        THEN 1
                                                    ELSE 0
                                                    END
                                            ),0) f_fist_count,
                                ISNULL(
                                        SUM(
                                                CASE
                                                    WHEN di.f_is_defect = 'true' and f_device_type='二级隐患'
                                                        THEN 1
                                                    ELSE 0
                                                    END
                                            ),0) f_second_count,
                                ISNULL(
                                        SUM(
                                            CASE
                                                WHEN di.f_is_defect = 'true' and f_device_type='三级隐患'
                                                    THEN 1
                                                ELSE 0
                                                END
                                        ),0) f_third_count
                            FROM
                                t_paper_devices pd WITH(NOLOCK)
                                LEFT JOIN t_devices_items di WITH(NOLOCK) ON di.f_is_defect = 'true' and di.f_device_id = pd.id
                            group by f_paper_id
                        ) pd1 on pd1.f_paper_id=cp.id
		WHERE
			ui.f_user_state  = '正常'
			AND ui.f_filialeid in {f_filialeids}
	) t_temp
left join t_userfiles tu on t_temp.f_userinfo_id=tu.f_userinfo_id and tu.f_table_state = '正常'
left join t_user_address tud on t_temp.f_userinfo_id=tud.f_userinfo_id
) t_temp2
--     left join (
--         select dil.f_deal_remark,pd.f_paper_id as id from  t_paper_devices pd
--             LEFT JOIN t_devices_items di ON di.f_device_id = pd.id
--             LEFT JOIN t_devices_items_lists dil ON dil.f_item_id= di.id where dil.f_deal_remark is not null and dil.f_deal_remark != '')
--         t23 on t_temp2.id = t23.id
WHERE
		{condition}
ORDER BY
	f_offsite_time
