SELECT *
FROM (
         SELECT pd.f_paper_id,
                pd.f_device_type,
                di.id,
                di.f_item_name,
                di.f_path,
                di.f_audit_results,
                di.f_repair_path,
                di.f_repairman,
                di.f_repair_date,
                di.f_deal_dispose,
                dil.f_item_value,
                tcpi.f_no_checkplan,
                tcp.f_address,
                tcp.f_user_name,
                tcp.f_sign_path,
                (case
                     when di.f_defect_level = '一级隐患' then 'A'
                     when di.f_defect_level = '二级隐患' then 'B'
                     when di.f_defect_level = '三级隐患' then 'C'
                     else '' end
                    ) as f_defect_level,
                tcpi.f_safecheck_type,
                (
                    CASE
                        WHEN di.f_is_defect = 'true' AND di.f_deal_dispose = '未处理' AND di.f_is_repaired = '已处理'
                            THEN '已处理'
                        WHEN di.f_is_defect = 'true' THEN di.f_deal_dispose
                        ELSE '无隐患'
                        END
                    )    f_repaire_type,
                (
                    CASE
                        WHEN di.f_is_defect != 'true' THEN 1
                        WHEN di.f_is_defect = 'true' AND di.f_user_changes = '是' THEN 2
                        WHEN di.f_is_defect = 'true' AND di.f_live_dispose = '是' THEN 3
                        WHEN di.f_is_defect = 'true' AND di.f_is_repaired = '已处理' THEN 4
                        WHEN di.f_is_defect = 'true' AND di.f_is_repaired = '转维修' THEN 5
                        ELSE 10
                        END
                    )    f_danger_leave
         FROM t_paper_devices pd
                  LEFT JOIN t_devices_items di ON di.f_device_id = pd.id
                  LEFT JOIN t_devices_items_lists dil ON dil.f_item_id = di.id
                  left join t_check_paper tcp on tcp.id = pd.f_paper_id
                  left join t_check_plan_item tcpi on tcp.f_check_item_id = tcpi.id
         WHERE pd.f_paper_id = '{f_paper_id}'
     ) t_temp
WHERE
    {condition}
ORDER BY f_danger_leave DESC