SELECT
    tcb.*,
    isnull( num.num, 0 ) AS num,
    isnull( num2.num, 0 ) AS num2,
    isnull( num3.num, 0 ) AS num3,
    isnull( num4.num, 0 ) AS num4,
    isnull( num5.num, 0 ) AS num5,
    CASE

        WHEN bookplan.xiafa IS NULL THEN
            0 ELSE bookplan.xiafa
        END xiafa,
    CASE

        WHEN bookplan.weijian IS NULL THEN
            0 ELSE bookplan.weijian
        END weijian,
    CASE

        WHEN bookplan.yijian IS NULL THEN
            0 ELSE bookplan.yijian
        END yijian,
    CASE

        WHEN bookplan.feixiafa IS NULL THEN
            0 ELSE bookplan.feixiafa
        END feixiafa,
    CASE

        WHEN bookplan.feiweijian IS NULL THEN
            0 ELSE bookplan.feiweijian
        END feiweijian,
    CASE

        WHEN bookplan.feiyijian IS NULL THEN
            0 ELSE bookplan.feiyijian
        END feiyijian
FROM
    t_check_book tcb
        LEFT JOIN (
        SELECT
            ta.f_check_book_id,
            COUNT ( 0 ) AS num
        FROM
            t_userinfo tui
                LEFT JOIN t_userfiles tuf ON tui.f_userinfo_id= tuf.f_userinfo_id
                LEFT JOIN t_user_address tua ON tuf.f_userinfo_id = tua.f_userinfo_id
                LEFT JOIN t_area ta ON tua.f_residential_area_id = ta.id
        WHERE
            ta.f_check_book_id IS NOT NULL
          AND tui.f_user_state != '销户'
		AND tui.f_user_state != '拆迁销户'
		AND tui.f_user_state != ''
		AND ( tuf.f_table_state= '正常' OR tuf.f_table_state= '停用' )
        GROUP BY
            ta.f_check_book_id
    ) num ON tcb.id= num.f_check_book_id
        LEFT JOIN ( SELECT ta.f_check_book_id, COUNT ( 0 ) AS num FROM t_area ta WHERE f_check_book_id IS NOT NULL GROUP BY ta.f_check_book_id ) num2 ON tcb.id= num2.f_check_book_id
        LEFT JOIN ( SELECT tc.f_check_book_id, COUNT ( 0 ) AS num FROM t_company tc WHERE f_check_book_id IS NOT NULL GROUP BY tc.f_check_book_id ) num3 ON tcb.id= num3.f_check_book_id
        LEFT JOIN (
        SELECT
            tc.f_check_book_id,
            COUNT ( 0 ) AS num
        FROM
            t_userinfo tui
                LEFT JOIN t_userfiles tuf ON tui.f_userinfo_id= tuf.f_userinfo_id
                LEFT JOIN t_company tc ON tui.f_corporate_name_id = tc.id
        WHERE
            tc.f_check_book_id IS NOT NULL
          AND tui.f_user_state != '销户'
		AND tui.f_user_state != '拆迁销户'
		AND tui.f_user_state != ''
		AND ( tuf.f_table_state= '正常' OR tuf.f_table_state= '停用' )
        GROUP BY
            tc.f_check_book_id
    ) num4 ON tcb.id= num4.f_check_book_id
        LEFT JOIN (
        SELECT
            tc.f_check_book_id,COUNT(0) AS num
        FROM
            t_userinfo tui
                LEFT JOIN t_userfiles tuf ON tui.f_userinfo_id= tuf.f_userinfo_id
                LEFT JOIN t_company tc ON tui.f_corporate_name_id = tc.id
                LEFT JOIN t_check_book tcb ON tc.f_check_book_id= tcb.id
                LEFT JOIN (
                SELECT
                    tcpi.id itemid,tcpi.f_userinfoid
                FROM
                    t_check_plan tcp
                        LEFT JOIN t_check_plan_item tcpi ON tcp.id= tcpi.f_plan_id
                WHERE
                    f_check_book_id != ''
            AND f_check_book_id IS NOT NULL
            AND f_plan_year = YEAR (
            GETDATE()) and f_plan_month = MONTH (
							GETDATE())
            ) tp on tp.f_userinfoid = tui.f_userinfo_id
        WHERE
            tc.f_check_book_id IS NOT NULL
          AND tui.f_user_state != '销户'
					AND tui.f_user_state != '拆迁销户'
					AND tui.f_user_state != ''
          and  (ui.f_usegas != '封堵'  or  ui.f_usegas is null )
					AND ( tuf.f_table_state= '正常' OR tuf.f_table_state= '停用' )
					and tp.itemid is null
        group by tc.f_check_book_id
    ) num5 ON tcb.id= num5.f_check_book_id
        LEFT JOIN (
        SELECT
            f_check_book_id,
            COUNT ( 0 ) xiafa,
            SUM ( weijian1 ) weijian,
            SUM ( yijian1 ) yijian,
            SUM ( feixiafa ) feixiafa,
            SUM ( feiweijian ) feiweijian,
            SUM ( feiyijian ) feiyijian
        FROM
            (
                SELECT
                    *,
                    CASE

                        WHEN f_state = '未检' THEN
                            1 ELSE 0
                        END AS weijian1,
                    CASE

                        WHEN f_state = '已检' THEN
                            1 ELSE 0
                        END AS yijian1,
                    CASE

                        WHEN f_state = '未检'
                            AND f_plan_month = MONTH (
                            GETDATE()) THEN
					1 ELSE 0
				END AS feiweijian,
			CASE

					WHEN f_state = '已检'
					AND f_plan_month = MONTH (
						GETDATE()) THEN
						1 ELSE 0
					END AS feiyijian,
				CASE

						WHEN f_plan_month = MONTH (
							GETDATE()) THEN
							1 ELSE 0
						END AS feixiafa,
						ROW_NUMBER ( ) OVER ( partition BY f_userinfoid ORDER BY f_create_time DESC ) AS lastcheck
        FROM
            (
            SELECT
            tcp.f_check_book_id,
            tcp.f_plan_month,
            tcpi.*
            FROM
            t_check_plan tcp
            LEFT JOIN t_check_plan_item tcpi ON tcp.id= tcpi.f_plan_id
            WHERE
            f_check_book_id != ''
            AND f_check_book_id IS NOT NULL
            AND f_plan_year = YEAR (
            GETDATE())
            ) tp
    ) t
WHERE
        lastcheck = 1
GROUP BY
    f_check_book_id
    ) bookplan ON tcb.id = bookplan.f_check_book_id
WHERE
    { condition }
ORDER BY
    tcb.id
