SELECT
	*
FROM (
	SELECT
		t_temp.*,f_meter_book_num,f_slice_area,
		case when tlg.black_num is null or tlg.black_num  = 0 then '否' else '是' end as f_is_black,
		(
			CASE f_defect_count
				WHEN 0
					THEN '无隐患'
				ELSE '有隐患'
			END
		) f_has_defect,
		(
			CASE WHEN f_repair_count=f_defect_count
					THEN '已完成'
				ELSE '未完成'
			END
		) f_is_repair,
		(
			CASE WHEN f_deal_count=f_defect_count
					THEN '已处理'
				ELSE '未处理'
			END
		) f_is_deal
	FROM (
		SELECT
			cp.id,
			cp.f_entry_status,
			cp.f_residential_area,
			cp.f_user_phone,
			cp.f_userinfo_code,
			cp.f_user_name,
			cp.f_onsite_time,
			cp.f_offsite_time,
			cp.f_checker_name,
			cp.f_repaired,
			ua.f_address,
			cp.f_check_plan_id,
			cpl.f_plan_name,
			ui.f_userinfo_id,
			ui.f_filialeid,
			f_defect_content,
			{f_defect_content} defecttext,
            pd1.*
		FROM
			t_check_paper cp
			LEFT JOIN t_check_plan cpl ON cpl.id = cp.f_check_plan_id
			LEFT JOIN t_userinfo ui ON ui.f_userinfo_id = cp.f_userinfoid
			LEFT JOIN t_user_address ua ON ua.f_userinfo_id = cp.f_userinfoid
		    LEFT JOIN (
                            SELECT
                                pd.f_paper_id,
                                ISNULL(
                                        SUM(
                                           CASE di.f_is_defect
                                            WHEN 'true'
                                                THEN 1
                                            ELSE 0
                                        END
                                ),0) f_defect_count,
                                ISNULL(
                                        SUM(
                                           CASE
                                            WHEN di.f_live_dispose='是' or di.f_is_repaired='已处理'
                                                THEN 1
                                            ELSE 0
                                        END
                                ),0) f_repair_count,
                                ISNULL(
                                        SUM(
                                           CASE
                                            WHEN (di.f_live_dispose='是' or di.f_is_repaired is not null) and di.f_is_defect='true'
                                                THEN 1
                                            ELSE 0
                                        END
                                ),0) f_deal_count,
                                max(f_repairman) f_repairman,
                                ISNULL(
                                        SUM(
                                                CASE
                                                    WHEN di.f_is_defect = 'true' and di.f_defect_level='一级'
                                                        THEN 1
                                                    ELSE 0
                                                    END
                                            ),0) f_fist_count,
                                ISNULL(
                                        SUM(
                                                CASE
                                                    WHEN di.f_is_defect = 'true' and di.f_defect_level='二级'
                                                        THEN 1
                                                    ELSE 0
                                                    END
                                            ),0) f_second_count,
                                ISNULL(
                                        SUM(
                                            CASE
                                                WHEN di.f_is_defect = 'true' and di.f_defect_level='三级'
                                                    THEN 1
                                                ELSE 0
                                                END
                                        ),0) f_third_count,
                                ISNULL(
                                    SUM(
                                        CASE
                                            WHEN di.f_is_defect = 'true' and di.f_defect_level='一般'
                                                THEN 1
                                            ELSE 0
                                        END
                                    ),0
			                    ) f_yiban_count,
                                ISNULL(
                                    SUM(
                                        CASE
                                            WHEN di.f_is_defect = 'true' and di.f_defect_level='重大'
                                                THEN 1
                                            ELSE 0
                                        END
                                    ),0
                                ) f_zhongda_count
                            FROM
                                t_paper_devices pd WITH(NOLOCK)
                                LEFT JOIN t_devices_items di WITH(NOLOCK) ON di.f_is_defect = 'true' and di.f_device_id = pd.id
                            group by f_paper_id
                        ) pd1 on pd1.f_paper_id=cp.id
		WHERE
			ui.f_user_state  = '正常'
			AND ui.f_filialeid in {f_filialeids}
	) t_temp
left join t_userfiles tu on t_temp.f_userinfo_id=tu.f_userinfo_id
left join t_user_address tud on t_temp.f_userinfo_id=tud.f_userinfo_id
left join (select f_userinfo_id,count(0) as black_num from t_limit_gas where f_state = '有效' group by f_userinfo_id) tlg on tlg.f_userinfo_id = t_temp.f_userinfo_id
where tu.f_table_state = '正常' or tu.f_table_state = '停用'
) t_temp2
WHERE
		{condition}
ORDER BY
	f_offsite_time DESC
