SELECT
    *,
    case when f_repair_date = '****-**-** **:**:**' then '未处理' else '已处理' end as f_repair_result
FROM
    (
        SELECT
            tdi.id,
            tcp.f_userinfo_code,
            tcp.f_user_name,
            tcp.f_user_phone,
            tcp.f_residential_area,
            tcp.f_address,
            tcp.f_checker_name,
            tcp.f_offsite_time,
            tcp.f_filialeid,
            tpd.f_device_type,
            tdi.f_item_name,
            tdil.f_item_value,
            tdi.f_alias_name,
            tdi.f_handle_date,
            case when tcp.f_SafeToRepair_id is not null and tdi.f_is_repaired != '已处理' then '已处理未消除隐患' else '已处理已消除隐患' end as is_repaired,
            case when ( tdi.f_handle_date is null or tdi.f_handle_date = '' or tdi.f_repair_date is not null or tdi.f_deal_dispose='现场整改' ) then '' else (
                case when tdi.f_handle_date >= GETDATE() then '未逾期' else '已逾期' end
                ) end
                                                                                                                                              as f_is_handle,
            tdi.f_path,
            tdi.f_deal_dispose,
            tdi.f_longitude,
            tdi.f_latitude,
            tcp.f_upload_date,
            tcp.f_check_type,
            tcp.id as f_paper_id,
            tdi.id as f_defect_id,
            tud.f_pcd,
            tud.f_slice_area,
            CASE

                WHEN tdi.f_defect_level IS NULL
                    OR tdi.f_defect_level= '' THEN
                    '未定级' ELSE tdi.f_defect_level
                END f_defect_level,
            CASE
                WHEN tdi.f_is_defect != 'true' THEN '无隐患'
                WHEN tdi.f_is_defect = 'true' AND tdi.f_is_repaired = '已处理' THEN '维修已处理'
                WHEN tdi.f_is_defect = 'true' AND tdi.f_is_repaired = '转维修' THEN '转维修'
                WHEN tdi.f_is_defect = 'true' AND (tdi.f_user_changes = '是' or tdi.f_deal_dispose in ('自行处理', '自行整改')) THEN '用户自行整改'
                WHEN tdi.f_is_defect = 'true' AND (tdi.f_live_dispose = '是' or tdi.f_deal_dispose='现场整改') THEN '现场已处理'
                ELSE '隐患未处理'
                END f_is_repaired,
            CASE
                WHEN tdi.f_is_defect = 'true' AND (tdi.f_live_dispose = '是' or tdi.f_deal_dispose='现场整改') THEN tcp.f_checker_name
                WHEN tdi.f_repairman IS NULL THEN '***' ELSE tdi.f_repairman
                END f_repairman,
            CASE
                WHEN tdi.f_is_defect = 'true' AND (tdi.f_live_dispose = '是' or tdi.f_deal_dispose='现场整改') THEN tcp.f_offsite_time
                WHEN tdi.f_repair_date IS NULL THEN '****-**-** **:**:**' ELSE tdi.f_repair_date
                END f_repair_date
        FROM
            t_check_paper tcp
                LEFT JOIN t_paper_devices tpd ON tcp.id= tpd.f_paper_id
                LEFT JOIN t_devices_items tdi ON tpd.id= tdi.f_device_id
                left join t_user_address tud on tcp.f_userinfoid = tud.f_userinfo_id
                LEFT JOIN t_devices_items_lists tdil ON tdil.f_item_id= tdi.id
                LEFT JOIN t_user usr ON usr.id = tcp.f_checker_id
                left join t_userfiles tuf on tcp.f_userinfoid = tuf.f_userinfo_id and tuf.f_table_state!='换表'
        WHERE
            tdi.f_is_defect = 'true' and f_table_state in ('正常','停用')
    ) tt where { condition }
ORDER BY
    f_offsite_time DESC
