SELECT
    isnull( f_department_name, '' ) AS f_residential_area,
    isnull( f_checker_name, '' ) AS f_checker_name,
    isnull( SUM ( data1 ), 0 ) AS data1,
    isnull( SUM ( data2 ), 0 ) AS data2,
    isnull( SUM ( data3 ), 0 ) AS data3,
    isnull( SUM ( data4 ), 0 ) AS data4,
    isnull( SUM ( data5 ), 0 ) AS data5,
    isnull( SUM ( CASE WHEN data6 > 0 THEN 1 ELSE 0 END ), 0 ) AS data6,
    isnull( SUM ( CASE WHEN data7 > 0 THEN 1 ELSE 0 END ), 0 ) AS data7,
    CASE WHEN SUM ( CASE WHEN data7 > 0 THEN 1 ELSE 0 END ) > 0 THEN ( CAST ( CAST ( SUM ( CASE WHEN data7 > 0 THEN 1 ELSE 0 END ) * 1.0 * 100 / SUM ( data5 ) AS DECIMAL ( 10, 2 ) ) AS VARCHAR ( 50 ) ) + '%' ) ELSE '0.0%' END AS data8
FROM
    (
        SELECT
            f_department_name,
            f_checker_name,
            SUM ( CASE WHEN f_entry_status = '入户' THEN 1 ELSE 0 END ) AS data1,
            SUM ( CASE WHEN f_entry_status = '到访不遇' THEN 1 ELSE 0 END ) AS data2,
            SUM ( CASE WHEN f_entry_status = '拒检' THEN 1 ELSE 0 END ) AS data3,
            COUNT ( tcp.id ) AS data4,
            SUM ( CASE WHEN f_defect_content NOT LIKE '%正常%' THEN 1 ELSE 0 END ) AS data5,
            (
                SELECT SUM
                           ( CASE WHEN f_deal_dispose IN ( '报修', '现场整改' ) THEN 1 ELSE 0 END )
                FROM
                    t_devices_items tdi
                        LEFT JOIN t_paper_devices tpd ON tdi.f_device_id = tpd.id
                WHERE
                        tpd.f_paper_id = tcp.id
                  AND f_is_defect = 'true'
            ) AS data6,
            (
                SELECT SUM
                           ( CASE WHEN f_deal_dispose NOT IN ( '报修', '现场整改' ) OR f_is_repaired = '已处理' THEN 1 ELSE 0 END )
                FROM
                    t_devices_items tdi
                        LEFT JOIN t_paper_devices tpd ON tdi.f_device_id = tpd.id
                WHERE
                        tpd.f_paper_id = tcp.id
                  AND f_is_defect = 'true'
            ) AS data7
        FROM
            t_check_paper tcp
                LEFT JOIN t_user tu ON tcp.f_checker_id = tu.id
                LEFT JOIN t_department d ON tu.parentid = d.id
                LEFT JOIN t_organization o ON d.parentid = o.id
        WHERE
            { condition }
        GROUP BY
            f_department_name,
            f_checker_name,
            tcp.id
    ) a
GROUP BY
    f_department_name,
    f_checker_name