SELECT
	uf.f_user_id As id, --表档案id
    uf.f_position AS f_weizhi, --安装位置
	gb.f_manufacturers AS f_maker, --气表厂家
	gm.f_meter_style AS f_diaphgram_size, --气表型号
	gb.f_meter_brand AS f_aliasname, --气表品牌
	gb.f_meter_type AS f_meter_type, --气表类型
    uf.f_meter_base AS f_prior_reading, --气表底数
    uf.f_meternumber AS f_meter_no, --表号
    uf.f_aroundmeter AS f_flow_direction, --左右表
    uf.f_metertitles As f_metertitles, --表封号
    uf.f_meter_base As  f_metergasnums, --气表底数
	uf.f_initial_base AS f_initial_base, --表基数
	uf.f_total_fee, --累购金额
	case when uf.f_meter_classify='机表' then uf.f_meter_base else uf.f_total_gas end f_total_gas,--累购气量
	gb.f_collection_type, --购气类型(按金额，按气量)
    uf.f_meter_classify,
    tcp.f_entry_status as f_last_check_state, -- 安检状态
    tcp.f_offsite_time as f_last_check_date, -- 离开时间
    tcp.f_defect_content as f_last_check_result, -- 安检结果
    tcp.f_checker_name, -- 安检人员
	uf.version,
	uf.f_balance_amount,
    uf.f_balance_gas,
    uf.f_userfiles_id,
    sp.f_price_name,
    td.f_disable_count
FROM
	t_userfiles uf
LEFT JOIN t_user_address u on uf.f_userinfo_id=u.f_userinfo_id
left join t_userfees tuf on tuf.f_userinfo_id=uf.f_userinfo_id
LEFT JOIN t_gasbrand gb ON uf.f_gasbrand_id = gb.id
LEFT JOIN t_gasmodel gm on uf.f_gasmodel_id = gm.id
left join  (select * from t_stairprice
    where getdate()>=f_perform_date and getdate()<=f_end_date
    and f_state ='有效') sp sp on uf.f_price_id = sp.f_price_id
LEFT JOIN t_check_paper tcp on tcp.f_userinfoid = uf.f_userinfo_id and tcp.f_upload_date = (select max (f_upload_date) from t_check_paper where f_userinfoid = '{f_userid}')
LEFT JOIN (
        select
            f_userinfo_id,
            count(*) as f_disable_count
        from t_userproperties where f_state = '有效'
        group by f_userinfo_id
    ) td on td.f_userinfo_id =uf.f_userinfo_id
WHERE
	uf.f_userinfo_id = '{f_userid}' and uf.f_table_state in ('正常','停用','待开通') and
