SELECT
    *
FROM
    (
        SELECT
            tp.f_offsite_time,
            tp.ruhuid,
            ui.f_userinfo_id,
            ui.f_createfile_date,
            ui.f_userinfo_code,
            ua.f_street,
            ua.f_residential_area,
            ua.f_building,
            ua.f_unit,
            ua.f_floor,
            ua.f_room,
            ua.building,
            ua.unit,
            ua.floor,
            ua.f_address,
            ui.f_user_name,
            ui.f_user_phone,
            uf.f_meter_book_num,
            ua.f_slice_area,
            uf.f_user_type,
            uf.f_meternumber,
            uf.f_meter_brand,
            uf.f_meter_classify,
            uf.f_gasproperties,
            uf.f_gas_date,
            tp.f_entry_status f_last_check_state,
            CASE

                WHEN tp.f_entry_status = '入户' THEN
                    ({ f_defect_content }) ELSE '未知'
                END AS f_last_check_result,
            f_defect_content,
            ui.f_comments,
            ua.f_pcd,
            ui.version,
            ui.f_user_state,
            ui.f_filialeid,
            tp.f_checker_name,
            tp.f_offsite_time f_last_check_date,
            tp.f_checker_name f_last_checker
        FROM
            t_userinfo ui
                LEFT JOIN (
                SELECT
                    ( CASE PATINDEX ( '%[^0-9]%', f_building ) WHEN 0 THEN f_building ELSE 999 END ) building,
                    ( CASE PATINDEX ( '%[^0-9]%', f_unit ) WHEN 0 THEN f_unit ELSE 999 END ) unit,
                    ( CASE PATINDEX ( '%[^0-9]%', f_floor ) WHEN 0 THEN f_floor ELSE 999 END ) floor,
                    *
                FROM
                    t_user_address
            ) ua ON ui.f_userinfo_id = ua.f_userinfo_id
                LEFT JOIN (
                SELECT
                    f_user_type,
                    f_meter_book_num,
                    f_userinfo_id,
                    f_meter_classify,
                    f_gasproperties,
                    f_meternumber,
                    f_meter_brand,
                    f_gas_date
                FROM
                    t_userfiles tu
                        LEFT JOIN t_gasbrand gb ON tu.f_gasbrand_id = gb.id
                WHERE
                        (f_table_state = '正常' or f_table_state = '停用')
            ) uf ON ui.f_userinfo_id = uf.f_userinfo_id
                LEFT JOIN (
                SELECT
                    id ruhuid,
                    f_userinfoid,
                    f_offsite_time,
                    f_checker_name,
                    f_entry_status,
                    f_defect_content,
                    f_state
                FROM
                    (
                        SELECT
                            *,
                            ROW_NUMBER () over ( PARTITION BY f_userinfoid ORDER BY f_offsite_time DESC ) AS lastcheck
                        FROM
                            ( SELECT * FROM t_check_paper WITH ( nolock ) WHERE { condition.condition2 } ) tp
                    ) t
                WHERE
                        lastcheck = 1
            ) tp ON ui.f_userinfo_id = tp.f_userinfoid
    ) a
WHERE
    f_user_state != '无效' and f_user_state != '销户' and  { condition.condition1 }
ORDER BY
    { orderitem }
