select *
from (
         select case
                    when mm.f_check_book_name is null then tcb.f_check_book_name
                    else mm.f_check_book_name end f_check_book_name,
                case
                    when mm.f_check_book_id is null then tua.f_check_book_id
                    else mm.f_check_book_id end   f_check_book_id,
                tui.f_userinfo_id,
                tui.f_user_name,
                tui.f_userinfo_code,
                tui.f_user_phone,
                tuf.f_user_type,
                tua.f_address,
                tua.f_residential_area,
                tsp.f_gasproperties,
                tui.f_filialeid as                f_orgid
         from t_userinfo tui
                  left join t_user_address tua on tua.f_userinfo_id = tui.f_userinfo_id
                  left join t_check_book tcb on tua.f_check_book_id = tcb.id
                  left join (
             select ta.id, ta.f_check_book_id, tcb1.f_check_book_name
             from t_check_book tcb1
                      left join t_area ta ON tcb1.id = ta.f_check_book_id
         ) mm on tua.f_residential_area_id = mm.id
                  left join t_userfiles tuf ON tui.f_userinfo_id = tuf.f_userinfo_id
                  left join (select case
                                        when getdate() between f_perform_date and f_end_date then '使用中'
                                        when getdate() < f_perform_date then '预调价'
                                        when f_end_date is null then '有效'
                                        when f_state = '删除' then '删除'
                                        else '已作废' end f_price_state,
                                    f_gasproperties,
                                    f_price_id
                             from t_stairprice
                             where f_state = '有效') tsp
                            ON tsp.f_price_id = tuf.f_price_id
         where tui.f_user_state != '销户'
and (tuf.f_table_state='正常' or tuf.f_table_state='停用' or tuf.f_table_state='待开通')
     ) ui
where  {condition}
