select f_checker_name,
       yuefeng,
       SUM(isnull(yijian, 0))  AS yijian,
       SUM(isnull(jujian, 0))  AS jujian,
       SUM(isnull(ruhu, 0)) AS ruhu,
       SUM(isnull(daofang, 0)) AS daofang,
       SUM(isnull(yinhuan, 0)) AS yinhuan
from (
         select replace(substring(isnull(f_upload_date, '1399-01-01 00:00:00'), 0, 8), '-', '') yuefeng,
                f_checker_name,
                F_NO_CHECKPLAN,
                CASE
                    WHEN f_entry_status in ('入户','拒检') or (f_entry_status = '到访不遇' and f_check_version > 2)
                        AND F_NO_CHECKPLAN = '{f_no_checkplan}'
                        THEN 1
                    ELSE 0
                    END AS   yijian,
                CASE
                    WHEN f_entry_status = '入户'
                        AND F_NO_CHECKPLAN = '{f_no_checkplan}'
                        THEN 1
                    ELSE 0
                    END AS ruhu,
                CASE
                    WHEN f_entry_status = '到访不遇' and f_check_version > 2
                        AND F_NO_CHECKPLAN = '{f_no_checkplan}'
                        THEN 1
                    ELSE 0
                    END AS daofang,
                CASE
                    WHEN f_entry_status = '拒检'
                        AND F_NO_CHECKPLAN = '{f_no_checkplan}'
                        THEN 1
                    ELSE 0
                    END AS   jujian,
                CASE
                    WHEN f_defect_content like '%有隐患%'
                        AND F_NO_CHECKPLAN = '{f_no_checkplan}'
                        THEN 1
                    ELSE 0
                    END AS   yinhuan,
                f_upload_date
         from t_check_paper  with (nolock)  where f_filialeid in {f_filiale_id}
     ) paper
where f_checker_name is not null
  and {condition} AND F_NO_CHECKPLAN = '{f_no_checkplan}'
group by f_checker_name, yuefeng
order by yuefeng desc
