SELECT
    *
FROM
    (
        SELECT
            tcp.f_userinfo_code,
            tcp.f_user_name,
            tcp.f_user_phone,
            tcp.f_residential_area,
            tcp.f_address,
            tcp.f_checker_name,
            tcp.f_offsite_time,
            tcp.f_filialeid,
            tcp.f_check_type,
            tpd.f_device_type,
            tdi.f_item_name,
            tdil.f_item_value,
            tdil.f_dealpath,
            tdil.f_deal_remark,
            uf.f_meternumber,
            ui.f_user_state,
            gb.f_meter_brand,
            uf.f_position,
            uf.f_user_type,
            uf.f_gasproperties,
            uf.f_table_state,
            tdi.f_path,
            CASE

                WHEN tdi.f_defect_level IS NULL
                    OR tdi.f_defect_level= '' THEN
                    '未定级' ELSE tdi.f_defect_level
                END f_defect_level,
            CASE

                WHEN tdi.f_is_repaired IS NULL THEN
                    '未处理' ELSE tdi.f_is_repaired
                END f_is_repaired,
            CASE

                WHEN tdi.f_repairman IS NULL THEN
                    '***' ELSE tdi.f_repairman
                END f_repairman,
            CASE

                WHEN tdi.f_repair_date IS NULL THEN
                    '****-**-** **:**:**' ELSE tdi.f_repair_date
                END f_repair_date
        FROM
            t_check_paper tcp with (nolock)
				LEFT JOIN t_userfiles uf with (nolock) on tcp.f_userinfoid=uf.f_userinfo_id and uf.f_table_state in ('正常','封堵','停用')
            LEFT JOIN t_userinfo ui with (nolock) ON ui.f_userinfo_id = tcp.f_userinfoid
            LEFT JOIN t_gasbrand gb with (nolock) ON uf.f_gasbrand_id = gb.id
            LEFT JOIN t_paper_devices tpd with (nolock) ON tcp.id= tpd.f_paper_id
            LEFT JOIN t_devices_items tdi with (nolock) ON tpd.id= tdi.f_device_id
            LEFT JOIN t_devices_items_lists tdil with (nolock) ON tdil.f_item_id= tdi.id
        WHERE
            tdi.f_is_defect = 'true' and { condition }
    ) tt
ORDER BY
    f_offsite_time DESC
