select
    id,
    f_plan_name,
    case f_issued
        when '是' then '已下发'
        when '否' then '未下发'
    end
    as f_issued,
    f_plan_year,
    f_plan_month,
    f_schedule_type,
    f_share_company_name,
    f_share_type,
    f_checker,
    f_checker_id,
    (SELECT count(id) FROM t_check_plan_item WHERE f_plan_id = cp.id and f_state !='作废') plan_count,
    (SELECT count(id) FROM t_check_plan_item WHERE f_plan_id = cp.id and f_state ='已检') checked,
    (SELECT count(id) FROM t_check_plan_item WHERE f_plan_id = cp.id and f_state ='未检') unchecked,
    (SELECT count(id) FROM t_check_plan_item WHERE f_plan_id = cp.id ) plan_allcount,
    cp.f_safecheck_type,
    cp.f_create_time
from t_check_plan cp
where {condition}
and f_plan_type in ('预约计划','预约任务')
and f_filialeid in {f_filialeids}
{
groupitem !=$$:
$,
group by {groupitem}
$,
groupitem ==$$:
$$,
$$
}
order by {orderitem}
