package com.aote.util;

import cn.hutool.core.io.FastByteArrayOutputStream;
import cn.hutool.extra.qrcode.BufferedImageLuminanceSource;
import com.google.zxing.*;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

/*二维码工具类*/

public class QRCodeUtil {
        //二维码颜色
        private static final int black = 0xff000000;
        //二维码颜色
        private static final int white = 0xffffffff;


/*       * <span style="font-size:18px;font-weight:blod;">zxing 方式生成二维码</span>
         * @param text <a href="javascript:void();" rel="external nofollow" >二维码内容</a>
         * @param width 二维码宽
         * @param height 二维码高
         * @param imagetype  二维码生成格式
         * */


         public static String zxingcodecreate(String text,int width,int height,String imagetype){
           Map<EncodeHintType,String> his=new HashMap<EncodeHintType,String>();
           //1.设置编码字符集
           his.put(EncodeHintType.CHARACTER_SET,"UTF-8");
            // 转换流信息写出
            FastByteArrayOutputStream os = new FastByteArrayOutputStream();
           try{
               //2.生成二维码
               BitMatrix encode=new MultiFormatWriter().encode(text,BarcodeFormat.QR_CODE,width,height,his);
               //3.获取二维码的宽和高
               int codewidth= encode.getWidth();
               int codeheight= encode.getHeight();
               //将二维码放入缓冲流
               BufferedImage image=new BufferedImage(codewidth,codeheight,BufferedImage.TYPE_INT_RGB);
               for (int i = 0; i < codewidth; i++) {
                   for (int j = 0; j < codeheight; j++) {
                       //4、循环将二维码内容定入图片
                       image.setRGB(i, j, encode.get(i, j) ? black : white);
                   }
               }
               ImageIO.write(image,imagetype,os);
           }catch (WriterException e) {
               e.printStackTrace();
               System.out.println("二维码生成失败");
           } catch (IOException e) {
               e.printStackTrace();
               System.out.println("生成二维码图片失败");
           }
            //如果二维码要在前端显示需要转成Base64
            return Base64.getEncoder().encodeToString(os.toByteArray());
        }

/**
     * <span style="font-size:18px;font-weight:blod;">二维码解析</span>
     * @param analyzepath 二维码路径
     * @return
     * @throws IOException*/
        @SuppressWarnings({ "rawtypes", "unchecked" })
        public static Object zxingcodeanalyze(String analyzepath) throws Exception{
            MultiFormatReader formatReader=new MultiFormatReader();
            Object result=null;
            try {
                File file=new File(analyzepath);
                if(!file.exists()){
                    return "二维码不存在";
                }
                BufferedImage image=ImageIO.read(file);
                LuminanceSource source=new BufferedImageLuminanceSource(image);
                Binarizer binarizer=new HybridBinarizer(source);
                BinaryBitmap binaryBitmap=new BinaryBitmap(binarizer);
                Map hints=new HashMap();
                hints.put(EncodeHintType.CHARACTER_SET,"UTF-8");
                result = formatReader.decode(binaryBitmap, hints);
                }catch (NotFoundException e) {
                e.printStackTrace();
            }
            System.out.println(result);
            return result;
            }

}


