package com.aote.util;

import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.*;
import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PdfUtils {

    /**
         * 根据PDF模版生成PDF文件
         * @param templateFilePath PDF模版文件路径
         * @param data 表单数据
         * @param imageData 图片数据 name为图片文件路径  {name:"真实路径"}
         * @param formFlattening false：生成后的PDF文件表单域仍然可编辑 true：生成后的PDF文件表单域不可编辑
         * @param pdfFilePath 生成PDF的文件路径
         * @param urlshow ""
     */
    public static String createPDF(String templateFilePath, JSONObject data, JSONObject imageData,Boolean formFlattening,String pdfFilePath,String urlshow) throws Exception{
        File file = null;
        PdfReader reader = null;
        ByteArrayOutputStream bos = null;
        PdfStamper pdfStamper = null;
        FileOutputStream fos = null;
        String filenaeme = null;
        try{
            reader = new PdfReader(templateFilePath);
            bos = new ByteArrayOutputStream();
            pdfStamper = new PdfStamper(reader, bos);
            AcroFields form = pdfStamper.getAcroFields();
            BaseFont bfChinese = BaseFont.createFont("STSongStd-Light", "UniGB-UCS2-H", BaseFont.NOT_EMBEDDED);
            form.addSubstitutionFont(bfChinese);
            for(String key : data.keySet()){
                form.setField(key,data.getString(key),true);
                form.setFieldProperty(key, "textfont", bfChinese, null);
            }
            if(null != imageData && imageData.length() > 0){
                for(String key : imageData.keySet()){
                    int pageNo = form.getFieldPositions(key).get(0).page;
                    Rectangle signRect = form.getFieldPositions(key).get(0).position;
                    float x = signRect.getLeft();
                    float y = signRect.getBottom();
                    Image image = Image.getInstance(imageData.getString(key));
                    PdfContentByte under = pdfStamper.getOverContent(pageNo);
                    image.scaleToFit(signRect.getWidth(), signRect.getHeight());
                    image.setAbsolutePosition(x, y);
                    under.addImage(image);
                }
            }
            pdfStamper.setFormFlattening(formFlattening);
            pdfStamper.close();
            String path = "";
            if(pdfFilePath.endsWith("jpg")){
                path = pdfFilePath.replace(".jpg",".pdf");
            }else if (pdfFilePath.endsWith("png")){
                path = pdfFilePath.replace(".png",".pdf");
            }
            file = new File(path);
            fos = new FileOutputStream(file);
            fos.write(bos.toByteArray());
            fos.flush();
            filenaeme = file.getAbsolutePath();
        }finally {
            if(null != fos){
                try {fos.close(); }catch (Exception e){e.printStackTrace();}
            }
            if(null != bos){
                try {bos.close(); }catch (Exception e){e.printStackTrace();}
            }
            if(null != reader){
                try {reader.close(); }catch (Exception e){e.printStackTrace();}
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("f_filename",filenaeme.split("\\\\")[filenaeme.split("\\\\").length-1]);
        jsonObject.put("f_realpath",filenaeme);
        return String.valueOf(jsonObject);
    }
}
