package com.aote.rs;

import com.aote.ThreadResource;
import com.aote.exception.FileNotFoundException;
import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlServer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.inject.Singleton;
import javax.ws.rs.*;
import java.io.*;
import java.net.URL;
import java.nio.charset.StandardCharsets;


@Path("safe_vue")
@Singleton
@Component
public class SafeVueService {

    @Autowired
    private SqlServer sqlServer;

    @Autowired
    private VueService vueService;
    /**
     * 执行业务逻辑(GET方式)
     *
     * @param  vueName 业务逻辑名称
     * @param folderName 文件夹名称
     * @return 执行结果
     */
    @GET
    @Transactional
    @Path("{vue}")
    public String getVueConfig(@PathParam("vue") String vueName, @QueryParam("folderName") String folderName,@QueryParam("orgDir") String orgDir)throws Exception {
        ThreadResource.ComponentDir.set(orgDir);
        return vueService.getVueConfig(vueName, folderName);
    }
    @GET
    @Transactional
    @Path("dir/{vue}")
    public String getVueConfigForid(@PathParam("vue") String dirid) throws Exception{
        JSONObject jsons = new JSONObject();
        JSONArray query = sqlServer.query("select * from t_organization where id = '" + dirid + "'");
        if(query.length()!=1) {
            throw new WebException(704, "用户没有特殊目录！");
        }
        JSONObject queryobj = (JSONObject) query.get(0);
        String f_dir = (String) queryobj.get("f_dir");
        if(f_dir == null || "".equals(f_dir)){
            throw new WebException(704, "用户没有特殊目录！");
        }
        try {
            //获取目录下所有文件名
            URL url = this.getClass().getClassLoader().getResource(f_dir +"/phonevues/");
            if (url == null) {
                url = this.getClass().getClassLoader().getResource("phonevues/");
            }
            String path = url.getPath();
            File[] files = new File(path).listFiles();
            for (File f :files){
                //读取文件内容
                String fileName = f.getName();
                StringBuffer strbuffer = new StringBuffer();
                FileInputStream fis = new FileInputStream(f);
                InputStreamReader inputStreamReader = new InputStreamReader(fis, "UTF-8");
                BufferedReader in  = new BufferedReader(inputStreamReader);
                String str;
                while ((str = in.readLine()) != null) {
                    strbuffer.append(str);
                }
                in.close();
                //将文件内容转为json并保存
                JSONObject json = new JSONObject(strbuffer.toString().trim());
                jsons.put(fileName.substring(0,fileName.indexOf(".")),json);
            }
            return jsons.toString();
        }catch (FileNotFoundException e){
            throw new WebException(704, "文件不存在: "+e.getPath());
        }
    }
    @GET
    @Transactional
    public String getPhoneVueConfig() throws Exception{
        JSONObject jsons = new JSONObject();
        String dir = ThreadResource.ComponentDir.get();
        if (dir == null || "".equals(dir)){
            throw new WebException(704, "用户没有特殊目录！");
        }
        try {
            //获取目录下所有文件名
            URL url = this.getClass().getClassLoader().getResource(dir +"/phonevues/");
            if (url == null) {
                url = this.getClass().getClassLoader().getResource("phonevues/");
            }
            String path = url.getPath();
            File[] files = new File(path).listFiles();
            for (File f :files){
                //读取文件内容
                String fileName = f.getName();
                StringBuffer strbuffer = new StringBuffer();
                FileInputStream fis = new FileInputStream(f);
                InputStreamReader inputStreamReader = new InputStreamReader(fis, "UTF-8");
                BufferedReader in  = new BufferedReader(inputStreamReader);
                String str;
                while ((str = in.readLine()) != null) {
                    strbuffer.append(str);
                }
                in.close();
                //将文件内容转为json并保存
                JSONObject json = new JSONObject(strbuffer.toString().trim());
                jsons.put(fileName.substring(0,fileName.indexOf(".")),json);
            }
            return jsons.toString();
        }catch (FileNotFoundException e){
            throw new WebException(704, "文件不存在: "+e.getPath());
        }
    }

    /**
     * 保存json
     *
     * @param value {path: '文件路径', data: 'json字符串'}
     * @return 结果
     * @throws Exception
     */
    @POST
    @Path("saveVueConfig")
    public String saveVueConfig(String value) {
        String path = null;
        String data;
        File file;
        try {
            JSONObject json = new JSONObject(value);
            path = String.valueOf(json.get("path"));
            data = formatJson(String.valueOf(json.get("data")));
            URL url = getClass().getClassLoader().getResource(path);
            file = new File(url.getFile());
            try (
                    FileOutputStream fos = new FileOutputStream(file);
                    OutputStreamWriter osw = new OutputStreamWriter(fos, StandardCharsets.UTF_8);
                    BufferedWriter b = new BufferedWriter(osw);
            ) {
                b.write(data);
                b.flush();
                return file.getAbsolutePath();
            }
        } catch (Exception e) {
            throw new WebException(500, "保存文件失败: " + path + "=>" + e);
        }

    }

    /**
     * 格式化json字符串
     * @param jsonStr json字符串
     * @return 格式化后的json字符串
     */
    public static String formatJson(String jsonStr) {
        if (null == jsonStr || "".equals(jsonStr)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char last;
        char current = '\0';
        int indent = 0;
        for (int i = 0; i < jsonStr.length(); i++) {
            last = current;
            current = jsonStr.charAt(i);
            switch (current) {
                case '{':
                case '[':
                    sb.append(current);
                    sb.append('\n');
                    indent++;
                    addIndentBlank(sb, indent);
                    break;
                case '}':
                case ']':
                    sb.append('\n');
                    indent--;
                    addIndentBlank(sb, indent);
                    sb.append(current);
                    break;
                case ',':
                    sb.append(current);
                    if (last != '\\') {
                        sb.append('\n');
                        addIndentBlank(sb, indent);
                    }
                    break;
                default:
                    sb.append(current);
            }
        }
        return sb.toString();
    }

    /**
     * 添加space
     *
     * @param sb
     * @param indent
     */
    public static void addIndentBlank(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; i++) {
            sb.append('\t');
        }
    }
}
