SELECT
    f_userinfoid
FROM
    t_check_plan_item
WHERE
    f_state = '未检'
    AND
    f_userinfoid IN (
        SELECT
            f_userinfo_id
        FROM (
            SELECT
                ui.f_userinfo_id,
                ui.f_createfile_date,
                f_userinfo_code,
                ua.f_residential_area f_area,
                ua.f_street,
                ua.f_residential_area,
                ua.f_building,
                ua.f_unit,
                ua.f_floor,
                ua.f_room,
                ua.f_address,
                f_user_name,
                f_user_phone,
                uf.f_user_type,
                f_last_check_state,
                f_last_check_result,
                ui.f_comments,
                ui.version,
                ui.f_filialeid,
                ISNULL(ISNULL(ua.f_last_check_date,CONVERT(varchar(50),f_gas_date,23)),CONVERT(varchar(50),f_createfile_date,23)) f_last_check_date,
                DATEDIFF({timetype}, ISNULL(ISNULL(ua.f_last_check_date,f_gas_date),f_input_date),GETDATE()) f_time
            FROM
                t_userfiles uf
                left join t_userinfo ui ON uf.f_userinfo_id = ui.f_userinfo_id
                LEFT JOIN t_user_address ua ON ui.f_userinfo_id = ua.f_userinfo_id
            WHERE
                uf.f_userinfo_id IS NOT NULL
                AND ui.f_user_state  = '正常'
                AND ui.f_filialeid in {f_filialeids}
        ) a
        WHERE
            {condition}
    )
ORDER BY f_userinfoid
