SELECT
    *
FROM
    (
        SELECT
            pd.f_paper_id,
            pd.f_device_type,
            di.id,
            di.f_item_name,
            di.f_path,
            di.f_repair_path,
            di.f_repairman,
            di.f_repair_date,
            dil.f_item_value,
            CASE

                WHEN di.f_is_defect != 'true' THEN
                    '无隐患'
                WHEN di.f_is_defect = 'true'
                    AND di.f_user_changes = '是' THEN
                    '用户自行整改'
                WHEN di.f_is_defect = 'true'
                    AND di.f_live_dispose = '是' THEN
                    '现场已处理'
                WHEN di.f_is_defect = 'true'
                    AND di.f_is_repaired = '已处理' THEN
                    '维修已处理'
                WHEN di.f_is_defect = 'true'
                    AND di.f_is_repaired = '转维修' THEN
                    '转维修' ELSE '隐患未处理'
                END f_repaire_type,
            CASE

                WHEN di.f_is_defect != 'true' THEN
                    1
                WHEN di.f_is_defect = 'true'
                    AND di.f_user_changes = '是' THEN
                    2
                WHEN di.f_is_defect = 'true'
                    AND di.f_live_dispose = '是' THEN
                    3
                WHEN di.f_is_defect = 'true'
                    AND di.f_is_repaired = '已处理' THEN
                    4
                WHEN di.f_is_defect = 'true'
                    AND di.f_is_repaired = '转维修' THEN
                    5 ELSE 10
                END f_danger_leave
        FROM
            t_paper_devices pd { entity.findDialect ( ) == $SqlServer$:$ WITH ( nolock ) $, $ $}
                LEFT JOIN t_devices_items di { entity.findDialect ( ) == $SqlServer$:$ WITH ( nolock ) $, $ $} ON di.f_device_id = pd.id
                LEFT JOIN t_devices_items_lists dil { entity.findDialect ( ) == $SqlServer$:$ WITH ( nolock ) $, $ $} ON dil.f_item_id= di.id
        WHERE
                pd.f_paper_id = '{f_paper_id}'
    ) t_temp
WHERE
    {condition}
ORDER BY
    f_danger_leave DESC