SELECT f_order_man,
	COUNT ( 0 ) AS num,
	SUM ( CONVERT(NUMERIC(19,1),guanchang) ) AS guanchang,
	SUM ( CONVERT(NUMERIC(19,1),kuaijie) ) AS kuaijie,
	SUM ( CONVERT(NUMERIC(19,1),duisi )) AS duisi 
FROM
	( SELECT serviceid, f_order_man FROM t_servicework WHERE f_workorder_type = '置换通气单' and {condition}) swo
	LEFT JOIN (
	SELECT
		serviceid,
	CASE
			
			WHEN MAX ( a.[管长（米）] ) IS NULL THEN
			'0' ELSE MAX ( a.[管长（米）] ) 
		END AS guanchang,
	CASE
			
			WHEN MAX ( a.[快接（个）] ) IS NULL THEN
			'0' ELSE MAX ( a.[快接（个）] ) 
		END AS kuaijie,
	CASE
			
			WHEN MAX ( a.[对丝（个）] ) IS NULL THEN
			'0' ELSE MAX ( a.[对丝（个）] ) 
		END AS duisi 
	FROM
		(
		SELECT
			sw.serviceid,
			f_project,
		CASE
				
				WHEN d.f_content IS NULL THEN
				'0' ELSE d.f_content 
			END f_content 
FROM
	t_servicework sw
	LEFT JOIN t_servicerepair sr ON sw.id= sr.serviceid
	LEFT JOIN t_details d ON sr.id= d.f_service_id 
WHERE
	sw.f_workorder_type = '置换通气单' 
	AND sr.f_type= '置换作业' 
	) tt PIVOT ( MAX ( tt.f_content ) FOR tt.f_project IN ( [管长（米）], [快接（个）], [对丝（个）] ) ) a 
GROUP BY
	a.serviceid 
	) con ON swo.serviceid= con.serviceid 
GROUP BY
	f_order_man