SELECT
d1.f_subcompany, --分公司
d1.dename, --部门
d1.f_checker_name, --安检员

isnull(d2.itemnum,0) itemnum, --安检总数
isnull(d3.centry,0) centry,  --入户
isnull(d3.cdeny,0) cdeny,   --拒检
isnull(d3.cabsent,0) cabsent,  --到访不遇
isnull(round((centry/cast(itemnum as float))*100,1),0)  centrysale, --入户率
isnull(d3.hidden,0) hidden,  --隐患
isnull(d3.normal,0) normal,   --正常
isnull(round((hidden/cast(itemnum as float))*100,1),0) hiddensale, --隐患率
isnull(d3.Repairpr,0) repairpr,  --转维修
isnull(d3.sitepr,0) sitepr,   --现场处理
isnull(d3.userpr,0) userpr   --用户处理


FROM
(
--分公司 部门
SELECT
  toz.name f_subcompany,
  td.name dename,
	tp.f_checker_id,
	tp.f_checker_name

FROM
	t_check_paper tp,
	t_department td,
    t_organization toz,
    t_user  tu
WHERE
 tp.f_checker_id=tu.id
and tu.parentid=td.id
and td.parentid=toz.id
{
  f_subcompany!=$$:
  $ and toz.name='{f_subcompany}'$,
  $$
}
{
  plantype==$临时安检$:
  $
    and tp.f_no_checkplan='无计划安检'
  $,$$
}
{
  plantype==$计划安检$:
  $
   and tp.f_check_plan_id in  (SELECT f_check_plan_id from  t_check_paper tp,t_check_plan tcp where tp.f_check_plan_id=tcp.id
    and tp.f_no_checkplan!='无计划安检' and tcp.f_checker is not null)
  $,$$
}
{
  plantype==$集中安检$:
  $
  and tp.f_check_plan_id in  (SELECT f_check_plan_id from  t_check_paper tp,t_check_plan tcp where tp.f_check_plan_id=tcp.id
    and tp.f_no_checkplan!='无计划安检' and tcp.f_checker is  null)
  $,$$
}
{
startDate!=$$:$ and  f_offsite_time>='{startDate}'$,$$
}
{
endDate!=$$:$  and  f_offsite_time<='{endDate}'$,$$
}
GROUP BY
 toz.name,
  td.name,
  tp.f_checker_name,
	tp.f_checker_id
)d1 LEFT JOIN
(
SELECT f_checker_id,count(*) itemnum
from (
SELECT f_entry_status,f_checker_id,f_userinfoid,f_no_checkplan,max(f_offsite_time) f_offsite_time
from
t_check_paper
where
 1=1
{
  plantype==$临时安检$:
  $
   and f_no_checkplan='无计划安检'
  $,$$
}
{
  plantype==$计划安检$:
  $
   and  f_check_plan_id in  (SELECT f_check_plan_id from  t_check_paper tp,t_check_plan tcp where tp.f_check_plan_id=tcp.id
    and tp.f_no_checkplan!='无计划安检' and tcp.f_checker is not null)
  $,$$
}
{
  plantype==$集中安检$:
  $
   and  f_check_plan_id in  (SELECT f_check_plan_id from  t_check_paper tp,t_check_plan tcp where tp.f_check_plan_id=tcp.id
    and tp.f_no_checkplan!='无计划安检' and tcp.f_checker is  null)
  $,$$
}
{
startDate!=$$:$ and  f_offsite_time>='{startDate}'$,$$
}
{
endDate!=$$:$  and  f_offsite_time<='{endDate}'$,$$
}
GROUP BY f_entry_status,f_checker_id,f_userinfoid,f_no_checkplan
) o1
GROUP BY o1.f_checker_id
)d2 on d1.f_checker_id=d2.f_checker_id LEFT JOIN(
SELECT
c1.f_checker_id,
isnull(c1.centry,0) centry,
isnull(c1.cdeny,0) cdeny,
isnull(c1.cabsent,0) cabsent,
isnull(c2.hidden,0) hidden,
isnull(c2.normal,0) normal,
isnull(c3.Repairpr,0) Repairpr,
isnull(c3.sitepr,0) sitepr,
isnull(c3.userpr,0) userpr
from

(
--入户情况
SELECT
tp.f_checker_id,
sum(case when tp.f_entry_status = '入户'  then 1 else 0 end) centry,
sum(case when tp.f_entry_status = '拒检'  then 1 else 0 end) cdeny,
sum(case when tp.f_entry_status = '到访不遇'  then 1 else 0 end) cabsent
FROM
(
SELECT f_entry_status,f_checker_id,f_userinfoid,f_no_checkplan,max(f_offsite_time) f_offsite_time
from
t_check_paper
where
 1=1
{
  plantype==$临时安检$:
  $
   and f_no_checkplan='无计划安检'
  $,$$
}
{
  plantype==$计划安检$:
  $
   and   f_check_plan_id in  (SELECT f_check_plan_id from  t_check_paper tp,t_check_plan tcp where tp.f_check_plan_id=tcp.id
    and tp.f_no_checkplan!='无计划安检' and tcp.f_checker is not null)
  $,$$
}
{
  plantype==$集中安检$:
  $
  and f_check_plan_id in  (SELECT f_check_plan_id from  t_check_paper tp,t_check_plan tcp where tp.f_check_plan_id=tcp.id
    and tp.f_no_checkplan!='无计划安检' and tcp.f_checker is  null)
  $,$$
}
{
startDate!=$$:$ and  f_offsite_time>='{startDate}'$,$$
}
{
endDate!=$$:$  and  f_offsite_time<='{endDate}'$,$$
}
GROUP BY f_entry_status,f_checker_id,f_userinfoid,f_no_checkplan
) tp
GROUP BY tp.f_checker_id
) c1 LEFT JOIN

(
--隐患情况
SELECT c.f_checker_id,
sum(case when c.normal>0 then 1 else 0 end) normal,
sum(case when c.hidden>0  then 1 else 0 end) hidden
from (
SELECT
s1.f_checker_id,
s1.f_no_checkplan,
s1.f_userinfoid,
sum(case when s4.f_is_defect != 'true' or s4.f_is_defect is null then 1 else 0 end) normal,
sum(case when s4.f_is_defect = 'true'  then 1 else 0 end) hidden,
max(s1.f_offsite_time) f_offsite_time
from
(
SELECT f_checker_id,f_userinfoid,f_check_item_id,f_no_checkplan,max(f_offsite_time) f_offsite_time
from
t_check_paper
WHERE
 1=1
{
  plantype==$临时安检$:
  $
   and f_no_checkplan='无计划安检'
  $,$$
}
{
  plantype==$计划安检$:
  $
   and  f_check_plan_id in  (SELECT f_check_plan_id from  t_check_paper tp,t_check_plan tcp where tp.f_check_plan_id=tcp.id
    and tp.f_no_checkplan!='无计划安检' and tcp.f_checker is not null)
  $,$$
}
{
  plantype==$集中安检$:
  $
  and f_check_plan_id in  (SELECT f_check_plan_id from  t_check_paper tp,t_check_plan tcp where tp.f_check_plan_id=tcp.id
    and tp.f_no_checkplan!='无计划安检' and tcp.f_checker is  null)
  $,$$
}
{
startDate!=$$:$ and  f_offsite_time>='{startDate}'$,$$
}
{
endDate!=$$:$  and  f_offsite_time<='{endDate}'$,$$
}
GROUP BY f_checker_id,f_userinfoid,f_no_checkplan,f_check_item_id
) s1
LEFT JOIN t_check_paper s2 on  s1.f_offsite_time=s2.f_offsite_time
  and s1.f_userinfoid=s2.f_userinfoid  and s1.f_no_checkplan=s2.f_no_checkplan

LEFT JOIN t_paper_devices s3 on s2.id=s3.f_paper_id
LEFT JOIN t_devices_items s4 on s3.id=s4.f_device_id
GROUP BY s1.f_checker_id,s1.f_no_checkplan,s1.f_userinfoid
) c
GROUP BY c.f_checker_id
)c2 on c1.f_checker_id=c2.f_checker_id LEFT JOIN

(
--隐患处理
SELECT c.f_checker_id,
sum(case when c.sitepr>0 then 1 else 0 end) sitepr,
sum(case when c.userpr>0 then 1 else 0 end) userpr,
sum(case when c.Repairpr>0  then 1 else 0 end) Repairpr
from (
SELECT
z1.f_checker_id,
z1.f_no_checkplan,
z1.f_userinfoid,
sum(case when z4.f_live_dispose= '是' then 1 else 0 end) sitepr,
sum(case when z4.f_user_changes = '是'  then 1 else 0 end) userpr,
sum(case when z2.f_SafeToRepair_id is not null  then 1 else 0 end) Repairpr,
max(z1.f_offsite_time) f_offsite_time
from
(
SELECT f_checker_id,f_userinfoid,f_check_item_id,f_no_checkplan,max(f_offsite_time) f_offsite_time
from
t_check_paper
WHERE
 1=1
{
  plantype==$临时安检$:
  $
  and  f_no_checkplan='无计划安检'
  $,$$
}
{
  plantype==$计划安检$:
  $
  and  f_check_plan_id in  (SELECT f_check_plan_id from  t_check_paper tp,t_check_plan tcp where tp.f_check_plan_id=tcp.id
    and tp.f_no_checkplan!='无计划安检' and tcp.f_checker is not null)
  $,$$
}
{
  plantype==$集中安检$:
  $
  and f_check_plan_id in  (SELECT f_check_plan_id from  t_check_paper tp,t_check_plan tcp where tp.f_check_plan_id=tcp.id
    and tp.f_no_checkplan!='无计划安检' and tcp.f_checker is  null)
  $,$$
}
{
startDate!=$$:$ and  f_offsite_time>='{startDate}'$,$$
}
{
endDate!=$$:$  and  f_offsite_time<='{endDate}'$,$$
}
GROUP BY f_checker_id,f_userinfoid,f_no_checkplan,f_check_item_id
) z1
LEFT JOIN t_check_paper z2 on  z1.f_offsite_time=z2.f_offsite_time
  and z1.f_userinfoid=z2.f_userinfoid  and z1.f_no_checkplan=z2.f_no_checkplan

LEFT JOIN t_paper_devices z3 on z2.id=z3.f_paper_id
LEFT JOIN t_devices_items z4 on z3.id=z4.f_device_id
GROUP BY z1.f_checker_id,z1.f_no_checkplan,z1.f_userinfoid
) c
GROUP BY c.f_checker_id
) c3 on c2.f_checker_id=c3.f_checker_id

)d3 on d1.f_checker_id =d3.f_checker_id