select sum(checked_rate) checked_rate,sum(household_rate) household_rate
 from(
    select case when t.checked_rate is null then 0 else t.checked_rate end checked_rate,
	   case when t.household_rate is null then 0 else t.household_rate end household_rate
	  from
  (
    select
    ROUND((CAST(t1.checked_count as float)/t2.plan_count)*100, 1) checked_rate,
    ROUND((CAST(t1.household_count as float)/t2.plan_count)*100, 1) household_rate from
    (select SUM(case when cpi.f_state='已检' then 1 else 0 end) checked_count,
    SUM(case when cpi.f_last_check_state='入户' then 1 else 0 end) household_count ,
    o.name as company,
    d.name as department
    from t_organization o
    join t_department d on o.id = d.parentid
    join t_user u on d.id = u.parentid
    join t_check_plan cp on u.id = cp.f_checker_id
    join t_check_plan_item cpi on cp.id = cpi.f_plan_id
    join (
          select * from(
          select *,ROW_NUMBER() over(partition by f_userinfoid order by f_offsite_time)as lastcheck
          from (select * from t_check_paper where f_approved = '已审核') tp) t where lastcheck=1)
          tcp on tcp.f_check_item_id = cpi.id
    where cp.f_checker is not null
    {
      f_subcompany!=$$:
      $ and o.name = '{f_subcompany}'$,
      $$
    }
    {
      department!=$$:
      $
      and d.name = '{department}'
      $,$$
    }
      {
        startDate !=$$ && endDate == $$:
        $and cp.f_plan_year = SUBSTRING('{startDate}',1,4)$,
        $$
      }
      {
        startDate ==$$ && endDate != $$:
        $and cp.f_plan_year = SUBSTRING('{endDate}',1,4)$,
        $$
      }
      {
        startDate !=$$ && endDate != $$:
        $and (cp.f_plan_year = SUBSTRING('{startDate}',1,4) or cp.f_plan_year = SUBSTRING('{endDate}',1,4))$,
        $$
      }
      {
        startDate !=$$ :
        $and  tcp.f_onsite_time>='{startDate}'$,
        $$
      }
      {
      endDate !=$$ :
        $and  tcp.f_offsite_time<='{endDate}'$,
        $$
      }
      group by o.name ,d.name
    ) t1
    left join (
         select COUNT(0) plan_count,
          o.name as company,
          d.name as department
          from t_organization o
          join t_department d on o.id = d.parentid
          join t_user u on d.id = u.parentid
          join t_check_plan cp on u.id = cp.f_checker_id
          join t_check_plan_item cpi on cp.id = cpi.f_plan_id
        where cp.f_checker is not null
        {
        f_subcompany!=$$:
        $ and o.name = '{f_subcompany}'$,
        $$
        }
        {
        department!=$$:
        $
        and d.name = '{department}'
        $,$$
        }
        {
          startDate !=$$ && endDate == $$:
          $and cp.f_plan_year = SUBSTRING('{startDate}',1,4)$,
          $$
        }
        {
          startDate ==$$ && endDate != $$:
          $and cp.f_plan_year = SUBSTRING('{endDate}',1,4)$,
          $$
        }
        {
          startDate !=$$ && endDate != $$:
          $and (cp.f_plan_year = SUBSTRING('{startDate}',1,4) or cp.f_plan_year = SUBSTRING('{endDate}',1,4))$,
          $$
        }
         group by o.name ,d.name
      )t2 on t1.company = t2.company and t1.department = t2.department
    ) t
    union all
    select 0 checked_rate,0 household_rate
 ) tt
