select
mr.year,
isnull(mr.yearruhu,0) yearruhu,
isnull(md.yeardefectcount,0) yeardefectcount,
isnull(ml.yearlivecount,0) yearlivecount,
isnull(mt.yeartorepair,0) yeartorepair,
isnull(mp.yearpapercount,0) yearpapercount
from
(
  select
    SUBSTRING(f_offsite_time,0,5) year,
    COUNT(id) yearruhu from (
      select * from (
        select *,ROW_NUMBER() over(partition by f_userinfoid order by f_offsite_time)as lastcheck
        from (select * from t_check_paper where f_approved = '已审核') tp) t
        where lastcheck=1
    )t
    where SUBSTRING(f_offsite_time,0,5) >= SUBSTRING('{f_start_time}',0,5) and SUBSTRING(f_offsite_time,0,5) <= SUBSTRING('{f_end_time}',0,5)
    and f_entry_status = '入户'
   group by SUBSTRING(f_offsite_time,0,5)
) mr
left join
(
  select
    SUBSTRING(f_offsite_time,0,5) year,
    COUNT(id) yearpapercount
  from (
    select * from(
      select
        *,ROW_NUMBER() over(partition by f_userinfoid order by f_offsite_time)as lastcheck
        from (select * from t_check_paper where f_approved = '已审核') tp) t
    where lastcheck=1
  )t
  where f_defect_content like'%有隐患%' and
  SUBSTRING(f_offsite_time,0,5) >= SUBSTRING('{f_start_time}',0,5) and SUBSTRING(f_offsite_time,0,5) <= SUBSTRING('{f_end_time}',0,5)
  group by SUBSTRING(f_offsite_time,0,5)
) mp
on mp.year = mr.year
left join
(
  select
    SUBSTRING(tp.f_offsite_time,0,5) year,
    count(tp.id) yeardefectcount
    from (
      select * from(
        select *,ROW_NUMBER() over(partition by f_userinfoid order by f_offsite_time)as lastcheck
        from (select * from t_check_paper where f_approved = '已审核') tp) t
      where lastcheck=1
  )tp
  left join
  t_paper_devices tpd on tp.id = tpd.f_paper_id
  left join
  t_devices_items tdi on tpd.id = tdi.f_device_id
  where tp.f_defect_content like'%有隐患%' and
  SUBSTRING(tp.f_offsite_time,0,5) >= SUBSTRING('{f_start_time}',0,5) and SUBSTRING(tp.f_offsite_time,0,5) <= SUBSTRING('{f_end_time}',0,5)
  and tdi.f_is_defect = 'true'
  group by SUBSTRING(tp.f_offsite_time,0,5)
) md
on mr.year = md.year
left join
 (
  select
     SUBSTRING(tp.f_offsite_time,0,5) year,
     count(tp.id) yearlivecount
    from (
      select * from(
        select *,ROW_NUMBER() over(partition by f_userinfoid order by f_offsite_time)as lastcheck
        from (select * from t_check_paper where f_approved = '已审核') tp) t
      where lastcheck=1
  )tp
  left join
  t_paper_devices tpd on tp.id = tpd.f_paper_id
  left join
  t_devices_items tdi on tpd.id = tdi.f_device_id
  where tp.f_defect_content like'%有隐患%' and
  SUBSTRING(tp.f_offsite_time,0,5) >= SUBSTRING('{f_start_time}',0,5) and SUBSTRING(tp.f_offsite_time,0,5) <= SUBSTRING('{f_end_time}',0,5)
  and tdi.f_live_dispose = '是'
  group by SUBSTRING(tp.f_offsite_time,0,5)
) ml
on mr.year = ml.year
left join
(
    select SUBSTRING(f_offsite_time,0,5) year,
    COUNT(id) yeartorepair from (
      select * from(
        select *,ROW_NUMBER() over(partition by f_userinfoid order by f_offsite_time)as lastcheck
        from (select * from t_check_paper where f_approved = '已审核') tp) t
      where lastcheck=1
  )t
  where f_defect_content like'%有隐患%' and
  SUBSTRING(f_offsite_time,0,5) >= SUBSTRING('{f_start_time}',0,5) and SUBSTRING(f_offsite_time,0,5) <= SUBSTRING('{f_end_time}',0,5)
  and f_repairorder_id is not null
  group by SUBSTRING(f_offsite_time,0,5)
) mt
on mr.year = mt.year