SELECT
  aa.*, files.F_USER_TYPE,
  FILES.F_SENDCARD_DATE,
  dev.f_devices_type,
  address.f_residential_area,
  address.f_address,
  info.f_user_name,
  1 a
FROM
  (
    SELECT
      SUM (f_pregas) f_pregas,
      SUM (f_preamount) f_preamount,
      f_userinfo_id,
      f_card_id
    FROM
      (
        SELECT
          f_card_id,
          f_userinfo_id,
          f_operate_date,
          f_pregas,
          f_preamount
        FROM
          t_sellinggas
        WHERE
          f_operate_date >= TO_DATE ({condition.search_year} || '-01-01', 'yyyy-mm-dd')
          AND f_operate_date < TO_DATE ({condition.next_year} || '-01-01', 'yyyy-mm-dd')
          AND f_card_id IN -- search_year年之前，只有一次购气记录（发卡记录）
              (
                SELECT
                  f_card_id
                FROM
                  t_sellinggas
                WHERE
                  f_state = '有效'
                  AND f_operate_date < TO_DATE ({condition.search_year} || '-01-01', 'yyyy-mm-dd')
                  AND f_userinfo_id IN --发卡在next_year年以前
                      (
                        SELECT
                          f_userinfo_id
                        FROM
                          t_userfiles
                        WHERE
                          f_sendcard_date < TO_DATE (
                              {condition.next_year} || '-01-01 00:00:00',
                              'yyyy-mm-dd hh24:mi:ss'
                          )
                      )
                GROUP BY
                  f_card_id
                HAVING
                  COUNT (*) = 1
              )
        UNION ALL
        SELECT
          f_card_id,
          f_userinfo_id,
          f_operate_date,
          f_pregas,
          f_preamount
        FROM
          t_sellinggas
        WHERE f_operate_date >= TO_DATE ({condition.search_year} || '-01-01', 'yyyy-mm-dd')
        AND f_operate_date < TO_DATE ({condition.next_year} || '-01-01', 'yyyy-mm-dd')
        AND f_userinfo_id IN -- search_year年之前，只有一次购气记录（发卡记录）
          (
            SELECT
              f_userinfo_id
            FROM
              t_sellinggas
            WHERE
              f_state = '有效'
              AND f_operate_date >= TO_DATE ({condition.search_year} || '-01-01', 'yyyy-mm-dd')
              AND f_operate_date < TO_DATE ({condition.next_year} || '-01-01', 'yyyy-mm-dd')
              AND f_userinfo_id IN (
                SELECT
                  f_userinfo_id
                FROM
                  t_userfiles
                WHERE
                  f_sendcard_date >= TO_DATE ({condition.search_year} || '-01-01', 'yyyy-mm-dd')
                  AND f_sendcard_date < TO_DATE ({condition.next_year} || '-01-01', 'yyyy-mm-dd')
              )
            GROUP BY
              f_userinfo_id
            HAVING
              COUNT (*) >= 2
          )
      )
        where  1=1 {condition.dateCondition}
GROUP BY
      f_card_id,
      f_userinfo_id
  ) aa
  LEFT JOIN (
              SELECT
                f_userinfo_id,
                f_sendcard_date,
                f_user_type
              FROM
                t_userfiles
            ) files ON aa.f_userinfo_id = files.f_userinfo_id
  LEFT JOIN (
              SELECT
                f_userinfo_id,
                f_devices_type
              FROM
                t_devices
            ) dev ON aa.f_userinfo_id = dev.f_userinfo_id
  LEFT JOIN (
              SELECT
                f_userinfo_id,
                f_residential_area,
                f_address
              FROM
                t_user_address
            ) address ON aa.f_userinfo_id = address.f_userinfo_id
  LEFT JOIN (
              SELECT
                f_userinfo_id,
                f_user_name
              FROM
                t_userinfo
            ) info ON aa.f_userinfo_id = info.f_userinfo_id
  where f_pregas>=20 and  {condition.condition}
order by f_card_id