SELECT
  case when t1.f_plan_month<10 then (t1.f_plan_year || '-0' || t1.f_plan_month )
  else  (t1.f_plan_year || '-' || t1.f_plan_month )
  end f_date,
  t1.countPlan,
  t2.countRuhu,
  t3.countArea
FROM
  (
    SELECT
      f_plan_year,
      f_plan_month,
      COUNT (*) countPlan
    FROM
      t_check_plan cp
      LEFT JOIN T_CHECK_PLAN_ITEM cpi ON cp. ID = cpi.f_plan_id
      where f_plan_type = '集中安检' and F_ISSUED = '是'   and  ( f_plan_year || '-' || f_plan_month > SUBSTR('{startDay}',1,7)) and ( f_plan_year || '-0' || f_plan_month < SUBSTR('{endDay}',1,7))
    GROUP BY
      f_plan_year,
      f_plan_month
  ) t1
  LEFT JOIN (
              select f_plan_year,f_plan_month,COUNT (*) countRuhu from
                (
                   SELECT
                    f_plan_year,
                    f_plan_month,
                    COUNT (*) countRuhu
                  FROM
                    t_check_plan cp
                    LEFT JOIN T_CHECK_PLAN_ITEM cpi ON cp. ID = cpi.f_plan_id
                  WHERE
                    f_upload_state = '已传'
                    AND f_state = '已检'
                    AND f_last_check_state = '入户'
                    AND f_plan_type = '集中安检'
                    and F_ISSUED = '是'
                    and  ( f_plan_year || '-' || f_plan_month > SUBSTR('{startDay}',1,7)) and ( f_plan_year || '-0' || f_plan_month < SUBSTR('{endDay}',1,7))
                  GROUP BY
                    f_plan_year,
                    f_plan_month,
                    F_CARD_ID
                 ) t where countRuhu =1
              GROUP BY f_plan_year,f_plan_month
            ) t2 ON t1.f_plan_year = t2.f_plan_year
                    AND t1.f_plan_month = t2.f_plan_month
  LEFT JOIN (
              SELECT
                f_plan_year,
                f_plan_month,
                COUNT (*) countArea
              FROM
                (
                  SELECT
                    f_plan_year,
                    f_plan_month,
                    f_residential_area
                  FROM
                    t_check_plan cp
                    LEFT JOIN T_CHECK_PLAN_ITEM cpi ON cp. ID = cpi.f_plan_id
                  WHERE
                    f_upload_state = '已传'
                    AND f_state = '已检'
                    AND f_last_check_state = '入户'
                    AND f_plan_type = '集中安检'
                    and F_ISSUED = '是'
                    and  ( f_plan_year || '-' || f_plan_month > SUBSTR('{startDay}',1,7)) and ( f_plan_year || '-0' || f_plan_month < SUBSTR('{endDay}',1,7))
                  GROUP BY
                    f_plan_year,
                    f_plan_month,
                    f_residential_area
                ) T
              GROUP BY
                f_plan_year,
                f_plan_month
            ) t3 ON t3.f_plan_year = t2.f_plan_year
                    AND t3.f_plan_month = t2.f_plan_month

