SELECT 
	CPR.F_SIMPLE_UPLOAD_TIME,
	CPR.F_RESIDENTIAL_AREA,
	CPR.F_CHECKER_ID,
	CPR.F_CHECKER_NAME,
	SUM (
		CASE CPR.F_ENTRY_STATUS
			WHEN '到访不遇' THEN 1
			ELSE 0
		END
	) NOVISIT_COUNT,
	SUM (
		CASE CPR.F_ENTRY_STATUS
			WHEN '入户' THEN 1
			ELSE 0
		END
	) ENTRY_COUNT,				
	SUM (
		CASE CPR.F_ENTRY_STATUS
			WHEN '拒检' THEN 1
			ELSE 0
		END
	) REFUSE_COUNT,
	SUM (
		CASE CPR.F_VISIT_STATE
			WHEN '毛坯房' THEN 1
			ELSE 0
		END
	) ROUGH_HOUSE_COUNT,
	SUM (
		CASE
			WHEN CPR.F_RENT != '否' THEN 1
			ELSE 0
		END
	) RENT_COUNT,
	SUM (
		CASE
			WHEN CPR.F_SAFETOREPAIR_ID IS NOT NULL THEN 1
			ELSE 0
		END
	) TO_REPAIR_COUNT,
	SUM (
		CASE
			WHEN CPR.F_DEFECT_CONTENT LIKE '%有隐患%' THEN 1
			ELSE 0
		END
	) HAS_DEFECT_COUNT,
	SUM(PDR.METER_COVER_COUNT) METER_COVER_COUNT,
	SUM(PDR.ALWAYS_VENTILATION_COUNT) ALWAYS_VENTILATION_COUNT,
	SUM(PDR.STOP_METER_COUNT) STOP_METER_COUNT,
	SUM(PDR.GAS_NOT_MATCH_COUNT) GAS_NOT_MATCH_COUNT,
	SUM(PDR.METER_LEAK_COUNT) METER_LEAK_COUNT,
	SUM(PDR.BOILER_INSTALL_COUNT) BOILER_INSTALL_COUNT,
	SUM(PDR.HEATER_INSTALL_COUNT) HEATER_INSTALL_COUNT,
	SUM(PDR.FIRST_DEFECT_COUNT) FIRST_DEFECT_COUNT,
	SUM(PDR.HOSE_GENERAL_AGING_COUNT) HOSE_GENERAL_AGING_COUNT,
	SUM(PDR.HOSE_SERIOUS_AGING_COUNT) HOSE_SERIOUS_AGING_COUNT,
	SUM(PDR.HOSE_TOO_LONG_COUNT) HOSE_TOO_LONG_COUNT,
	SUM(PDR.HOSE_UNFIXED_COUNT) HOSE_UNFIXED_COUNT,
	SUM(PDR.HOSE_THROUGH_WALL_COUNT) HOSE_THROUGH_WALL_COUNT,
	SUM(PDR.HOSE_UNDERGROUND_COUNT) HOSE_UNDERGROUND_COUNT,
	SUM(PDR.HOSE_MULTIPLE_COUNT) HOSE_MULTIPLE_COUNT,
	SUM(PDR.HOSE_ADD_ADAPTER_COUNT) HOSE_ADD_ADAPTER_COUNT,
	SUM(PDR.HOSE_NOZZLE_LEAK_COUNT) HOSE_NOZZLE_LEAK_COUNT,
	SUM(PDR.RISER_UNFIXED_COUNT) RISER_UNFIXED_COUNT,
	SUM(PDR.RISER_PACKAGE_COUNT) RISER_PACKAGE_COUNT,
	SUM(PDR.TUBE_UNFIXED_COUNT) TUBE_UNFIXED_COUNT,
	SUM(PDR.TUBE_PACKAGE_COUNT) TUBE_PACKAGE_COUNT,
	SUM(PDR.TUBE_PRIVATE_CHANGE_COUNT) TUBE_PRIVATE_CHANGE_COUNT,
	SUM(PDR.TUBE_HANGING_OBJECTS_COUNT) TUBE_HANGING_OBJECTS_COUNT,
	SUM(PDR.TUBE_INSUFFICIENT_COUNT) TUBE_INSUFFICIENT_COUNT,
	SUM(PDR.TUBE_CHAOS_CONNECT_COUNT) TUBE_CHAOS_CONNECT_COUNT,
	SUM(PDR.TUBE_SOFT_TEE_COUNT) TUBE_SOFT_TEE_COUNT,
	SUM(PDR.ALARM_OVERDUE_COUNT) ALARM_OVERDUE_COUNT,
	SUM(PDR.METER_OVERDUE_COUNT) METER_OVERDUE_COUNT,
	SUM(PDR.COOKER_OVERDUE_COUNT) COOKER_OVERDUE_COUNT,
	SUM(PDR.COOKER_PROTECT_DAMAGE_COUNT) COOKER_PROTECT_DAMAGE_COUNT,
	SUM(PDR.COOKER_LEAK_COUNT) COOKER_LEAK_COUNT,
	SUM(PDR.HEATER_OVERDUE_COUNT) HEATER_OVERDUE_COUNT,
	SUM(PDR.HEATER_LEAK_COUNT) HEATER_LEAK_COUNT,
	SUM(PDR.HEATER_USE_HOSE_COUNT) HEATER_USE_HOSE_COUNT,
	SUM(PDR.HEATER_DIRECT_DISCHARGE_COUNT) HEATER_DIRECT_DISCHARGE_COUNT,
	SUM(PDR.HEATER_FLUE_DEFECT_COUNT) HEATER_FLUE_DEFECT_COUNT,
	SUM(PDR.BOILER_OVERDUE_COUNT) BOILER_OVERDUE_COUNT,
	SUM(PDR.BOILER_LEAK_COUNT) BOILER_LEAK_COUNT,
	SUM(PDR.BOILER_DIRECT_DISCHARGE_COUNT) BOILER_DIRECT_DISCHARGE_COUNT,
	SUM(PDR.BOILER_FLUE_DEFECT_COUNT) BOILER_FLUE_DEFECT_COUNT,
	SUM(PDR.OTHER_PLUGIN_UNSAFE_COUNT) OTHER_PLUGIN_UNSAFE_COUNT,
	SUM(PDR.OTHER_MULTIPLE_FIRE_COUNT) OTHER_MULTIPLE_FIRE_COUNT,
	SUM(PDR.OTHER_KITCHEN_LIVE_COUNT) OTHER_KITCHEN_LIVE_COUNT,
	SUM(PDR.OTHER_OPEN_STYLE_KITCHEN_COUNT) OTHER_OPEN_STYLE_KITCHEN_COUNT,
	SUM(PDR.OTHER_AIRTIGHT_KITCHEN_COUNT) OTHER_AIRTIGHT_KITCHEN_COUNT
FROM 
	(
		SELECT
			CPR.ID,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '燃气表' AND 
						 DI.F_ITEM_NAME = '表封' AND 
						 DIL.F_ITEM_VALUE = '钢质' 
						 THEN 1
					ELSE 0
				END
			) METER_COVER_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '燃气表' AND 
						 DI.F_ITEM_NAME = '表具故障' AND 
						 DIL.F_ITEM_VALUE = '常通' 
						 THEN 1
					ELSE 0
				END
			) ALWAYS_VENTILATION_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '燃气表' AND 
						 DI.F_ITEM_NAME = '表具故障' AND 
						 DIL.F_ITEM_VALUE = '死表' 
						 THEN 1
					ELSE 0
				END
			) STOP_METER_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '燃气表' AND 
						 DI.F_ITEM_NAME = '表具故障' AND 
						 DIL.F_ITEM_VALUE = '气量不符' 
						 THEN 1
					ELSE 0
				END
			) GAS_NOT_MATCH_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '燃气表' AND 
						 DI.F_ITEM_NAME = '表具故障' AND 
						 DIL.F_ITEM_VALUE = '表体漏气' 
						 THEN 1
					ELSE 0
				END
			) METER_LEAK_COUNT,		
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '壁挂锅炉' AND 
						 DI.F_ITEM_NAME = '是否安装' AND 
						 DIL.F_ITEM_VALUE = '是' 
						 THEN 1
					ELSE 0
				END
			) BOILER_INSTALL_COUNT,			
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '热水器' AND 
						 DI.F_ITEM_NAME = '是否安装' AND 
						 DIL.F_ITEM_VALUE = '是' 
						 THEN 1
					ELSE 0
				END
			) HEATER_INSTALL_COUNT,	
			CASE 
				WHEN 
					SUM (
						CASE
							WHEN DIL.F_ITEM_VALUE = '一级隐患' THEN 1
							ELSE 0
						END
					) > 0 
					THEN 1
				ELSE 0
			END FIRST_DEFECT_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '灶具连接管' AND 
						 DI.F_ITEM_NAME = '灶具连接管隐患类型' AND 
						 DIL.F_ITEM_VALUE = '一般老化' 
						 THEN 1
					ELSE 0
				END
			) HOSE_GENERAL_AGING_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '灶具连接管' AND 
						 DI.F_ITEM_NAME = '灶具连接管隐患类型' AND 
						 DIL.F_ITEM_VALUE = '严重老化' 
						 THEN 1
					ELSE 0
				END
			) HOSE_SERIOUS_AGING_COUNT,	
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '灶具连接管' AND 
						 DI.F_ITEM_NAME = '灶具连接管隐患类型' AND 
						 DIL.F_ITEM_VALUE = '过长' 
						 THEN 1
					ELSE 0
				END
			) HOSE_TOO_LONG_COUNT,	
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '灶具连接管' AND 
						 DI.F_ITEM_NAME = '灶具连接管隐患类型' AND 
						 DIL.F_ITEM_VALUE = '无管夹' 
						 THEN 1
					ELSE 0
				END
			) HOSE_UNFIXED_COUNT,	
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '灶具连接管' AND 
						 DI.F_ITEM_NAME = '灶具连接管隐患类型' AND 
						 DIL.F_ITEM_VALUE = '穿墙或穿顶' 
						 THEN 1
					ELSE 0
				END
			) HOSE_THROUGH_WALL_COUNT,	
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '灶具连接管' AND 
						 DI.F_ITEM_NAME = '灶具连接管隐患类型' AND 
						 DIL.F_ITEM_VALUE = '暗埋' 
						 THEN 1
					ELSE 0
				END
			) HOSE_UNDERGROUND_COUNT,	
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '灶具连接管' AND 
						 DI.F_ITEM_NAME = '灶具连接管隐患类型' AND 
						 DIL.F_ITEM_VALUE = '多根对接' 
						 THEN 1
					ELSE 0
				END
			) HOSE_MULTIPLE_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '灶具连接管' AND 
						 DI.F_ITEM_NAME = '灶具连接管隐患类型' AND 
						 DIL.F_ITEM_VALUE = '加装转接头' 
						 THEN 1
					ELSE 0
				END
			) HOSE_ADD_ADAPTER_COUNT,	
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '灶具连接管' AND 
						 DI.F_ITEM_NAME = '灶具连接管隐患类型' AND 
						 DIL.F_ITEM_VALUE = '接口漏气' 
						 THEN 1
					ELSE 0
				END
			) HOSE_NOZZLE_LEAK_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '立管' AND 
						 DI.F_ITEM_NAME = '立管隐患类型' AND 
						 DIL.F_ITEM_VALUE = '未固定' 
						 THEN 1
					ELSE 0
				END
			) RISER_UNFIXED_COUNT,	
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '立管' AND 
						 DI.F_ITEM_NAME = '立管隐患类型' AND 
						 DIL.F_ITEM_VALUE = '封闭包裹' 
						 THEN 1
					ELSE 0
				END
			) RISER_PACKAGE_COUNT,	
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '表后管' AND 
						 DI.F_ITEM_NAME = '表后管隐患类型' AND 
						 DIL.F_ITEM_VALUE = '未固定' 
						 THEN 1
					ELSE 0
				END
			) TUBE_UNFIXED_COUNT,	
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '表后管' AND 
						 DI.F_ITEM_NAME = '表后管隐患类型' AND 
						 DIL.F_ITEM_VALUE = '封闭包裹' 
						 THEN 1
					ELSE 0
				END
			) TUBE_PACKAGE_COUNT,	
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '表后管' AND 
						 DI.F_ITEM_NAME = '表后管隐患类型' AND 
						 DIL.F_ITEM_VALUE = '私改' 
						 THEN 1
					ELSE 0
				END
			) TUBE_PRIVATE_CHANGE_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '表后管' AND 
						 DI.F_ITEM_NAME = '表后管隐患类型' AND 
						 DIL.F_ITEM_VALUE = '挂物' 
						 THEN 1
					ELSE 0
				END
			) TUBE_HANGING_OBJECTS_COUNT,	
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '表后管' AND 
						 DI.F_ITEM_NAME = '表后管隐患类型' AND 
						 DIL.F_ITEM_VALUE = '安全间距不足' 
						 THEN 1
					ELSE 0
				END
			) TUBE_INSUFFICIENT_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '表后管' AND 
						 DI.F_ITEM_NAME = '表后管隐患类型' AND 
						 DIL.F_ITEM_VALUE = '用户私拉乱接' 
						 THEN 1
					ELSE 0
				END
			) TUBE_CHAOS_CONNECT_COUNT,	
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '表后管' AND 
						 DI.F_ITEM_NAME = '表后管隐患类型' AND 
						 DIL.F_ITEM_VALUE = '软三通' 
						 THEN 1
					ELSE 0
				END
			) TUBE_SOFT_TEE_COUNT,	
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '报警器' AND 
						 DI.F_ITEM_NAME = '到期时间' AND 
						 DIL.F_ITEM_VALUE < TO_CHAR(SYSDATE, 'YYYY-MM-DD') 
						 THEN 1
					ELSE 0
				END
			) ALARM_OVERDUE_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '燃气表' AND 
						 DI.F_ITEM_NAME = '生产时间' AND 
						 DIL.F_ITEM_VALUE < TO_CHAR(ADD_MONTHS(SYSDATE, -120), 'YYYY-MM-DD')
						 THEN 1
					ELSE 0
				END
			) METER_OVERDUE_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '灶具' AND 
						 DI.F_ITEM_NAME = '灶具隐患类型' AND 
						 DIL.F_ITEM_VALUE = '超期使用' 
						 THEN 1
					ELSE 0
				END
			) COOKER_OVERDUE_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '灶具' AND 
						 DI.F_ITEM_NAME = '灶具隐患类型' AND 
						 DIL.F_ITEM_VALUE = '无熄火保护或熄火保护失效' 
						 THEN 1
					ELSE 0
				END
			) COOKER_PROTECT_DAMAGE_COUNT,			
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '灶具' AND 
						 DI.F_ITEM_NAME = '灶具隐患类型' AND 
						 DIL.F_ITEM_VALUE = '漏气' 
						 THEN 1
					ELSE 0
				END
			) COOKER_LEAK_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '热水器' AND 
						 DI.F_ITEM_NAME = '热水器隐患类型' AND 
						 DIL.F_ITEM_VALUE = '超期使用' 
						 THEN 1
					ELSE 0
				END
			) HEATER_OVERDUE_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '热水器' AND 
						 DI.F_ITEM_NAME = '热水器隐患类型' AND 
						 DIL.F_ITEM_VALUE = '漏气' 
						 THEN 1
					ELSE 0
				END
			) HEATER_LEAK_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '热水器' AND 
						 DI.F_ITEM_NAME = '热水器隐患类型' AND 
						 DIL.F_ITEM_VALUE = '软管连接' 
						 THEN 1
					ELSE 0
				END
			) HEATER_USE_HOSE_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '热水器' AND 
						 DI.F_ITEM_NAME = '热水器隐患类型' AND 
						 DIL.F_ITEM_VALUE = '直排' 
						 THEN 1
					ELSE 0
				END
			) HEATER_DIRECT_DISCHARGE_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '热水器' AND 
						 DI.F_ITEM_NAME = '热水器隐患类型' AND 
						 (
						   DIL.F_ITEM_VALUE = '烟道破损' OR
						   DIL.F_ITEM_VALUE = '无烟道' OR
						   DIL.F_ITEM_VALUE = '安装不规范'
						 )
						 THEN 1
					ELSE 0
				END
			) HEATER_FLUE_DEFECT_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '壁挂锅炉' AND 
						 DI.F_ITEM_NAME = '壁挂锅炉隐患类型' AND 
						 DIL.F_ITEM_VALUE = '超期使用' 
						 THEN 1
					ELSE 0
				END
			) BOILER_OVERDUE_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '壁挂锅炉' AND 
						 DI.F_ITEM_NAME = '壁挂锅炉隐患类型' AND 
						 DIL.F_ITEM_VALUE = '漏气' 
						 THEN 1
					ELSE 0
				END
			) BOILER_LEAK_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '壁挂锅炉' AND 
						 DI.F_ITEM_NAME = '壁挂锅炉隐患类型' AND 
						 DIL.F_ITEM_VALUE = '直排' 
						 THEN 1
					ELSE 0
				END
			) BOILER_DIRECT_DISCHARGE_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '壁挂锅炉' AND 
						 DI.F_ITEM_NAME = '壁挂锅炉隐患类型' AND
							 (
								 DIL.F_ITEM_VALUE = '烟道未排出室外' OR
								 DIL.F_ITEM_VALUE = '烟道破损' OR
								 DIL.F_ITEM_VALUE = '无烟道' OR
								 DIL.F_ITEM_VALUE = '安装不规范'
							 )
						 THEN 1
					ELSE 0
				END
			) BOILER_FLUE_DEFECT_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '其他' AND 
						 DI.F_ITEM_NAME = '其他' AND 
						 DIL.F_ITEM_VALUE = '使用非安全规范插件' 
						 THEN 1
					ELSE 0
				END
			) OTHER_PLUGIN_UNSAFE_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '其他' AND 
						 DI.F_ITEM_NAME = '其他' AND 
						 DIL.F_ITEM_VALUE = '多种火源' 
						 THEN 1
					ELSE 0
				END
			) OTHER_MULTIPLE_FIRE_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '其他' AND 
						 DI.F_ITEM_NAME = '更改厨房用途' AND 
						 DIL.F_ITEM_VALUE = '卧室' 
						 THEN 1
					ELSE 0
				END
			) OTHER_KITCHEN_LIVE_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '其他' AND 
						 DI.F_ITEM_NAME = '其他' AND 
						 DIL.F_ITEM_VALUE = '开放式厨房' 
						 THEN 1
					ELSE 0
				END
			) OTHER_OPEN_STYLE_KITCHEN_COUNT,
			SUM (
				CASE
					WHEN PD.F_DEVICE_TYPE = '其他' AND 
						 DI.F_ITEM_NAME = '其他' AND 
						 DIL.F_ITEM_VALUE = '密闭式厨房' 
						 THEN 1
					ELSE 0
				END
			) OTHER_AIRTIGHT_KITCHEN_COUNT
		FROM 
			(
				SELECT
					ID,
					F_RESIDENTIAL_AREA,
					F_CHECKER_ID,
					SUBSTR(F_OFFSITE_TIME, 1, 10) F_SIMPLE_UPLOAD_TIME,
					RANK() OVER(PARTITION BY F_CHECK_ITEM_ID ORDER BY F_OFFSITE_TIME DESC) UPLOAD_TIME_RANK
				FROM
					T_CHECK_PAPER
				WHERE
					F_OFFSITE_TIME>= '{start_date} 00:00:00'
					and F_OFFSITE_TIME<= '{end_date} 23:59:59' and {mycondition}
			) CPR
			LEFT JOIN T_PAPER_DEVICES PD ON PD.F_PAPER_ID = CPR.ID
			LEFT JOIN T_DEVICES_ITEMS DI ON DI.F_DEVICE_ID = PD.ID
			LEFT JOIN T_DEVICES_ITEMS_LISTS DIL ON DIL.F_ITEM_ID = DI.ID
		WHERE
			UPLOAD_TIME_RANK = 1
		GROUP BY
			CPR.ID
	) PDR
	JOIN
	(
		SELECT
			ID,
			F_RESIDENTIAL_AREA,
			F_CHECKER_ID,
			F_CHECKER_NAME,
			F_ENTRY_STATUS,
			F_VISIT_STATE,
			F_RENT,
			F_SAFETOREPAIR_ID,
			F_DEFECT_CONTENT,
			F_OFFSITE_TIME,
			SUBSTR(F_OFFSITE_TIME, 1, 10) F_SIMPLE_UPLOAD_TIME
		FROM
			T_CHECK_PAPER
	) CPR ON CPR.ID = PDR.ID
GROUP BY
	CPR.F_SIMPLE_UPLOAD_TIME, CPR.F_RESIDENTIAL_AREA, CPR.F_CHECKER_ID, CPR.F_CHECKER_NAME
ORDER BY
	CPR.F_SIMPLE_UPLOAD_TIME, CPR.F_RESIDENTIAL_AREA, CPR.F_CHECKER_ID