/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import java.math.BigDecimal;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonCompare {
    private static Logger log = Logger.getLogger(JsonCompare.class);

    public static boolean hasKey(JSONObject jo, String attr) {
        return jo.has(attr);
    }

    public static JSONObject renoveEscapecharacter(JSONObject jo) {
        String json = jo.toString();
        JSONObject newJson = new JSONObject(json.replace('\n', ' '));
        log.debug((Object)("newjson" + newJson));
        return newJson;
    }

    public static JSONArray findDiff(JSONObject jo1, JSONObject jo2) {
        Set keySet1 = jo1.keySet();
        JSONArray jsonArray = new JSONArray();
        for (String s : keySet1) {
            if (!JsonCompare.isValueEquals(jo1, jo2, s)) continue;
            JSONObject jo = new JSONObject();
            jo.put("field", (Object)s);
            jo.put("newVal", jo1.get(s) == null ? null : jo1.get(s).toString().replace("null", ""));
            jo.put("oldVal", jo2.get(s) == null ? null : jo2.get(s).toString().replace("null", ""));
            if (jo.getString("newVal").equals(jo.getString("oldVal"))) continue;
            jsonArray.put((Object)jo);
        }
        return jsonArray;
    }

    private static boolean isValueEquals(JSONObject jo1, JSONObject jo2, String s) {
        if (jo1.has(s) && jo2.has(s)) {
            if (jo1.isNull(s) && !jo2.isNull(s) || !jo1.isNull(s) && jo2.isNull(s)) {
                return true;
            }
        } else {
            return false;
        }
        if (jo1.isNull(s) && (jo2.isNull(s) || "null".equals(jo2.get(s)))) {
            return false;
        }
        if (jo1.get(s) instanceof Integer) {
            if (jo2.get(s) instanceof BigDecimal) {
                return new BigDecimal((Integer)jo1.get(s)).compareTo((BigDecimal)jo2.get(s)) != 0;
            }
            try {
                return new BigDecimal((Integer)jo1.get(s)).compareTo(new BigDecimal(Integer.valueOf(jo2.get(s).toString()))) != 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (jo1.get(s) instanceof String) {
            if (jo2.get(s) instanceof String) {
                return !jo1.get(s).equals(jo2.get(s));
            }
            try {
                return new BigDecimal(Double.valueOf(jo1.get(s).toString())).compareTo((BigDecimal)jo2.get(s)) != 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (jo1.get(s) instanceof Double) {
            if (jo2.get(s) instanceof Integer) {
                return new BigDecimal((Double)jo1.get(s)).compareTo(new BigDecimal((Integer)jo2.get(s))) != 0;
            }
            try {
                return new BigDecimal((Double)jo1.get(s)).compareTo(new BigDecimal(Double.parseDouble(jo2.get(s).toString()))) != 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        return !jo2.get(s).equals(jo1.get(s));
    }
}

