SELECT
	T.f_card_id,
	pd.f_device_type f_device_name,
	MAX (
			CASE
			WHEN di.f_item_name = '是否安装' THEN
				f_item_value
			ELSE
				NULL
			END
	) f_has_install,
	MAX (
			CASE
			WHEN di.f_item_name = '安装时间' THEN
				f_item_value
			ELSE
				NULL
			END
	) f_install_time,
	MAX (
			CASE
			WHEN di.f_item_name = '品牌' THEN
				f_item_value
			ELSE
				NULL
			END
	) f_brand,
	MAX (
			CASE
			WHEN f_is_defect = 'true' THEN
				'是'
			ELSE
				'否'
			END
	) f_has_defect,
	MAX (
			CASE
			WHEN f_is_defect = 'true' THEN
				f_item_name
			ELSE
				NULL
			END
	) f_defect_type,
	MAX (
			CASE
			WHEN f_is_defect = 'true' THEN
				f_item_value
			ELSE
				NULL
			END
	) f_defect_value,
	MAX (
			CASE
			WHEN f_is_defect = 'true' THEN
				f_defect_level
			ELSE
				NULL
			END
	) f_defect_level
FROM
	(
		SELECT
			*
		FROM
			(
				SELECT
					ID,
					f_card_id,
					ROW_NUMBER () OVER (
					PARTITION BY F_CARD_ID
						ORDER BY
							F_OFFSITE_TIME DESC
						) lastday
				FROM
					(
						SELECT
							ID,
							f_card_id,
							F_OFFSITE_TIME
						FROM
							T_CHECK_PAPER
						WHERE
							f_entry_status = '入户'
							AND f_onsite_time >= '{start_time}'
							AND f_onsite_time <= '{end_time}'
					)
			) T
		WHERE
			lastday = 1
	) T
	LEFT JOIN (
							SELECT
								ID,
								F_DEVICE_TYPE,
								F_PAPER_ID
							FROM
								T_PAPER_DEVICES
							WHERE
								F_DEVICE_TYPE = '热水器'
							UNION ALL
							SELECT
								ID,
								F_DEVICE_TYPE,
								F_PAPER_ID
							FROM
								T_PAPER_DEVICES
							WHERE
								F_DEVICE_TYPE = '灶具'
							UNION ALL
							SELECT
								ID,
								F_DEVICE_TYPE,
								F_PAPER_ID
							FROM
								T_PAPER_DEVICES
							WHERE
								F_DEVICE_TYPE = '壁挂锅炉'
						) pd ON pd.F_PAPER_ID = T.ID
	LEFT JOIN (
							SELECT
								*
							FROM
								T_DEVICES_ITEMS
							WHERE
								f_create_time >= '{start_time}'
								AND f_create_time <= '{end_time}'
								AND f_item_name IS NOT NULL
						) di ON DI.f_device_id = pd.ID
	LEFT JOIN (
							SELECT
								*
							FROM
								T_DEVICES_ITEMS_LISTS
							WHERE
								f_create_time >= '{start_time}'
								AND f_create_time <= '{end_time}'
								AND f_item_value IS NOT NULL
						) dil ON dil.f_item_id = DI.ID
WHERE
	pd.f_device_type IS NOT NULL
GROUP BY
	T.f_card_id,
	pd.f_device_type
ORDER BY
	f_card_id