SELECT
	a.f_residential_area,    --小区
	a.f_area,
  a.f_street,
	case when a.f_special is null then '民用' else null end  f_user_type, --用户类型
	count(a.f_userinfo_id) f_user_num  --用户数
FROM
	(
	SELECT
		ui.f_userinfo_id,
		{ month != $$ :
		$1 code,
		$,
		$$
		}
		tua.f_residential_area,
		tua.f_pcd as f_area,
		tua.f_special,
		tua.f_street
	FROM
		t_userinfo ui left join t_user_address tua  on ui.f_userinfo_id=tua.f_userinfo_id
		left join t_userfiles uf
    on ui.f_userinfo_id = uf.f_userinfo_id
	WHERE
		{ condition }
		--地址f_special null 为空 非民用档案
		AND ui.f_userinfo_id IS NOT NULL 	And tua.f_special is null
		{ month != $$ :(
		 entity.findDialect()==$SqlServer$:
		 $AND datediff(month,ui.f_last_check_date,getdate()) >={ month }$,
         $AND months_between(sysdate ,ui.f_last_check_date)>={ month }$
         )
		,
		month == $$ :
		$
		AND 1 = 1 $,
		$$
		}

	) a
	GROUP BY 	f_residential_area,    --小区
	f_special,
	f_street,
	f_area
ORDER BY
	{ orderitem}
