SELECT
NVL (SUM(f_pregas), 0) f_pregas,
	f_residential_area,
	f_address,
	f_focususer_type,
	f_user_phone,
	f_card_id,
	f_is_rent,
	f_user_equipmen,
	f_writeback,
	f_is_entry,
	f_onsite_time,
	-- 入户情况
	f_indoor_circumstance,
	-- 备注
	f_remark
FROM
	(
		SELECT
			-- 小区
			f_residential_area,
			-- 楼房号
			f_building || '-' || cp.f_unit || '-' || cp.f_floor || '-' || cp.f_room f_address,
			-- 重点用户类型
			cp.f_focususer_type,
			-- 联系电话
			CP.f_user_phone,
			-- 卡号
			CP.f_card_id,
			-- 是否租住
			CASE
		WHEN f_rent = '否' THEN
			'否'
		ELSE
			'是'
		END f_is_rent,
		-- 用气设备
		f_user_equipmen,
		-- 总购气量
		f_pregas,
		-- 末次购气时间
		f_writeback,
		-- 是否入户
		CASE
	WHEN f_entry_status = '入户' THEN
		'是'
	ELSE
		'否'
	END f_is_entry,
	-- 入户时间
	f_onsite_time,
	-- 入户情况
	f_indoor_circumstance,
	-- 备注
	f_remark
FROM
	(
		SELECT
			f_residential_area,
			f_building,
			f_unit,
			f_floor,
			f_room,
			f_focususer_type,
			f_user_phone,
			f_card_id,
			f_rent,
			f_user_equipmen,
			f_entry_status,
			f_remark,
			f_onsite_time,
			f_indoor_circumstance
		FROM
			t_check_paper
		WHERE
			f_no_checkplan = '重点用户跟进单'
	) cp
LEFT JOIN t_userfiles uf ON uf.f_card_id = cp.f_card_id
LEFT JOIN t_userinfo ui ON ui.f_userinfo_id = uf.f_userinfo_id
LEFT JOIN (
	SELECT
		f_pregas,
		f_card_id
	FROM
		t_sellinggas
	WHERE
		f_state = '有效'
) b ON b.f_card_id = uf.f_card_id
	) b
WHERE
{condition}
GROUP BY
	f_residential_area,
	f_address,
	f_focususer_type,
	f_user_phone,
	f_card_id,
	f_is_rent,
	f_user_equipmen,
	f_writeback,
	f_is_entry,
	f_onsite_time,
	f_indoor_circumstance,
	f_remark
order by f_card_id