/*
 * Decompiled with CFR 0.152.
 */
package com.aote.transaction;

import com.af.plugins.RestTools;
import com.aote.ThreadResource;
import com.aote.transaction.ThreadSession;
import java.util.ArrayList;
import java.util.List;
import javassist.NotFoundException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SessionPool {
    @Autowired
    private SessionFactory factory;
    @Autowired
    private ThreadSession tSession;
    private InnerSession[] sessions = new InnerSession[100];
    private static SessionPool instance;

    public static SessionPool getInstance() {
        return instance;
    }

    private SessionPool() {
        instance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createSession() throws NotFoundException {
        Session session = this.factory.openSession();
        Transaction trans = session.beginTransaction();
        InnerSession innerSession = new InnerSession(session, trans);
        InnerSession[] innerSessionArray = this.sessions;
        synchronized (this.sessions) {
            for (int i = 0; i < this.sessions.length; ++i) {
                if (this.sessions[i] != null) continue;
                this.sessions[i] = innerSession;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return i;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            throw new NotFoundException("\u6ca1\u6709\u7a7a\u95f2\u4f4d\u7f6e");
        }
    }

    public int createCallSession(int i, String url) {
        return this.sessions[i].createCallSession(url);
    }

    public Session getSession(int i) {
        return this.sessions[i].session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(int i) {
        InnerSession session = this.sessions[i];
        session.transaction.commit();
        session.commitAll();
        InnerSession[] innerSessionArray = this.sessions;
        synchronized (this.sessions) {
            this.sessions[i] = null;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(int i) {
        InnerSession session = this.sessions[i];
        session.transaction.rollback();
        session.rollbackAll();
        InnerSession[] innerSessionArray = this.sessions;
        synchronized (this.sessions) {
            this.sessions[i] = null;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public Session getSession() {
        Session threadSession = this.tSession.get();
        if (threadSession != null) {
            return threadSession;
        }
        Integer sessionId = ThreadResource.SessionId.get();
        if (sessionId != null) {
            int i = sessionId;
            return this.getSession(i);
        }
        return this.factory.getCurrentSession();
    }

    private class CallSession {
        public String url;
        public int id;

        public CallSession(String url, int id) {
            this.url = url;
            this.id = id;
        }
    }

    private class InnerSession {
        public Session session;
        public Transaction transaction;
        private List<CallSession> chanSessions = new ArrayList<CallSession>();

        public InnerSession(Session session, Transaction transaction) {
            this.session = session;
            this.transaction = transaction;
        }

        public int createCallSession(String url) {
            String id = RestTools.post((String)url, (String)"{action:'begin'}");
            int result = Integer.parseInt(id);
            CallSession callSession = new CallSession(url, result);
            this.chanSessions.add(callSession);
            return result;
        }

        public void commitAll() {
            for (CallSession callSession : this.chanSessions) {
                RestTools.post((String)callSession.url, (String)("{action:'commit', id: " + callSession.id + "}"));
            }
        }

        public void rollbackAll() {
            for (CallSession callSession : this.chanSessions) {
                RestTools.post((String)callSession.url, (String)("{action:'rollback', id: " + callSession.id + "}"));
            }
        }
    }
}

