/*
 * Decompiled with CFR 0.152.
 */
package com.aote.module;

import com.aote.exception.FileNotFoundException;
import com.aote.logic.LogicMapper;
import com.aote.util.ResourceHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.json.JSONArray;
import org.json.JSONObject;

public class ModuleMapper {
    static Logger log = Logger.getLogger(LogicMapper.class);
    private static Map<String, Map<String, String>> map;
    private static Map<String, Map<String, String>> subclassmap;

    public static synchronized String getAttr(String module, String attr) {
        if (map == null) {
            ModuleMapper.loadMap();
        }
        if (map.containsKey(module)) {
            return map.get(module).get(attr);
        }
        return null;
    }

    public static synchronized Map<String, Map<String, String>> getSubClassMap() {
        if (subclassmap == null) {
            ModuleMapper.loadSubClassMap();
        }
        return subclassmap;
    }

    public static synchronized Map<String, Map<String, String>> getMap() {
        if (map == null) {
            ModuleMapper.loadMap();
        }
        return map;
    }

    private static void loadSubClassMap() {
        subclassmap = new HashMap<String, Map<String, String>>();
        if (ResourceHelper.class.getResourceAsStream("/subclass.json") == null) {
            log.debug((Object)"\u65e0subclass.json\u6587\u4ef6\uff0c\u7ee7\u627f\u5173\u7cfb\u6a21\u5757\u5316\u65e0");
            return;
        }
        String strConfig = null;
        try {
            strConfig = ResourceHelper.getString("subclass.json");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("subclass.json\u6587\u4ef6\u65e0\u914d\u7f6e");
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
        JSONArray json = new JSONArray(strConfig);
        for (Object obj : json) {
            JSONObject jo = (JSONObject)obj;
            String name = jo.getString("module");
            HashMap<String, String> module = new HashMap<String, String>();
            module.put("name", name);
            subclassmap.put(name, module);
        }
    }

    private static void loadMap() {
        map = new HashMap<String, Map<String, String>>();
        InputStream module = LogicMapper.class.getClassLoader().getResourceAsStream("module.xml");
        try {
            if (module == null) {
                throw new RuntimeException("\u6a21\u5757\u5b9a\u4e49\u6587\u4ef6module.xml\u672a\u627e\u5230");
            }
            ModuleMapper.parseModule(module);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void parseModule(InputStream input) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read(input);
        Element root = document.getRootElement();
        Iterator it = root.elementIterator("module");
        while (it.hasNext()) {
            Element elm = (Element)it.next();
            String name = elm.attribute("name").getValue();
            String upload = elm.attributeValue("upload");
            HashMap<String, String> module = new HashMap<String, String>();
            module.put("name", name);
            module.put("upload", upload);
            map.put(name, module);
        }
    }
}

