package com.aote.util;

import java.util.List;
import java.util.Map;

import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.orm.hibernate3.HibernateCallback;

import com.aote.sql.AliasTransformer;

public class SqlHelper {
	@SuppressWarnings("unchecked")
	public static JSONArray query(Session session, String sql) throws Exception {
		JSONArray array = new JSONArray();
		HibernateSQLCall sqlCall = new HibernateSQLCall(sql, 0, 9999999);
		sqlCall.transformer = AliasTransformer.INSTANCE;
		List<Map<String, Object>> list = (List<Map<String, Object>>) sqlCall
				.doInHibernate(session);
		for (Map<String, Object> map : list) {
			JSONObject json = (JSONObject) new JsonTransfer().MapToJson(map);
			array.put(json);
		}
		return array;
	}

	@SuppressWarnings("unchecked")
	public static JSONArray query(Session session, String sql, int pageNo,
			int pageSize) throws Exception {
		JSONArray array = new JSONArray();
		HibernateSQLCall sqlCall = new HibernateSQLCall(sql, pageNo, pageSize);
		sqlCall.transformer = AliasTransformer.INSTANCE;
		List<Map<String, Object>> list = (List<Map<String, Object>>) sqlCall
				.doInHibernate(session);
		for (Map<String, Object> map : list) {
			JSONObject json = (JSONObject) new JsonTransfer().MapToJson(map);
			array.put(json);
		}
		return array;
	}
	
	/**
	 * hql基本查询 
	 * @param session
	 * @param sql
	 * @return JSONArray
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static JSONArray hqlQuery(Session session,String sql) throws Exception
	{
		JSONArray array=new JSONArray();
		HibernateHQLCall sqlCall = new HibernateHQLCall(sql, 0, 9999999);
		List<Map<String, Object>> list = (List<Map<String, Object>>) sqlCall
				.doInHibernate(session);
		for (Map<String, Object> map : list) {
			JSONObject json = (JSONObject) new JsonTransfer().MapToJson(map);
			array.put(json);
		}
		
		return array;
	}
	/**
	 * hql分页查询
	 * @param session
	 * @param sql
	 * @param pageNo
	 * @param pageSize
	 * @return  JSONArray
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public static JSONArray hqlQuery(Session session, String sql, int pageNo,
			int pageSize) throws Exception {
		JSONArray array = new JSONArray();
		HibernateHQLCall sqlCall = new HibernateHQLCall(sql, pageNo, pageSize);
		List<Map<String, Object>> list = (List<Map<String, Object>>) sqlCall
				.doInHibernate(session);
		for (Map<String, Object> map : list) {
			JSONObject json = (JSONObject) new JsonTransfer().MapToJson(map);
			array.put(json);
		}
		return array;
	}
	

	/**
	 * 执行sql
	 *
	 * @param session
	 * @param sql
	 * @return
	 */
	public static int bulkUpdate(Session session, String sql) {
		Query queryObject = session.createQuery(sql);
		return new Integer(queryObject.executeUpdate()).intValue();
	}
	
	public static int bulkSQLUpdate(Session session, String sql) {
		Query queryObject = session.createSQLQuery(sql);
		return new Integer(queryObject.executeUpdate()).intValue();
	}

	@SuppressWarnings("rawtypes")
	public static class HibernateSQLCall implements HibernateCallback {
		String sql;
		int page;
		int rows;
		public ResultTransformer transformer = null;

		public HibernateSQLCall(String sql, int page, int rows) {
			this.sql = sql;
			this.page = page;
			this.rows = rows;
		}

		public Object doInHibernate(Session session) {
			Query q = session.createSQLQuery(sql);
			if (transformer != null) {
				q.setResultTransformer(transformer);
			}
			try {
				List result = q.setFirstResult(page * rows).setMaxResults(rows).list();
				return result;
			} catch (SQLGrammarException ex) {
				// 把sql语句添加到异常信息中
				String msg = "sql:\n" + sql + "\n" + ex.getMessage();
				throw new SQLGrammarException(msg, ex.getSQLException());
			}
		}
	}
	@SuppressWarnings("rawtypes")
	static class HibernateHQLCall implements HibernateCallback {
		String sql;
		int page;
		int rows;
		public ResultTransformer transformer = null;

		public HibernateHQLCall(String sql, int page, int rows) {
			this.sql = sql;
			this.page = page;
			this.rows = rows;
		}

		public Object doInHibernate(Session session) {
			Query q = session.createQuery(sql);
			if (transformer != null) {
				q.setResultTransformer(transformer);
			}
			try {
				List result = q.setFirstResult(page * rows).setMaxResults(rows).list();
				return result;
			} catch (SQLGrammarException ex) {
				// 把sql语句添加到异常信息中
				String msg = "sql:\n" + sql + "\n" + ex.getMessage();
				throw new SQLGrammarException(msg, ex.getSQLException());
			}
		}
	}

}
