package com.aote.timer;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;

public class CommonTarget implements ITarget {

	private List<String> urls;

	@Override
	public List<JSONArray> sendTarget(List<JSONArray> list) {
		List<JSONArray> resultList = new ArrayList<JSONArray>();
		for (int i = 0; i < list.size(); i++) {
			JSONArray result = send(urls.get(i), list.get(i));
			resultList.add(result);
		}
		return resultList;
	}

	// 发送数据给指定地址，并返回接收到的数据
	private JSONArray send(String url, JSONArray data) {
		System.out.println("url: " + url);
		System.out.println("data: " + data);
		try {
			// 创建POSTMethod
			HttpPost postMethod = new HttpPost(url);/* 建立HTTP Post连线 */
			StringEntity se = new StringEntity(data.toString(), "UTF-8");
			postMethod.setEntity(se);

			// 执行POSTMethod
			HttpClient httpClient = new DefaultHttpClient();
			postMethod.setHeader("Content-type", "application/json;charset=UTF-8");
			HttpResponse response = httpClient.execute(postMethod);
			int code = response.getStatusLine().getStatusCode();
			code = 200;
			if (code != 200) {
				throw new RuntimeException("send error");
			}
			String actual = EntityUtils.toString(response.getEntity(), "UTF-8");
			JSONArray array = new JSONArray(actual);
			return array;
		} catch (RuntimeException e) {
			throw e;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	public List<String> getUrls() {
		return urls;
	}

	public void setUrls(List<String> urls) {
		this.urls = urls;
	}
}
