package com.aote.sql;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/**
 * sql映射器
 * @author LGY
 *
 */
public class SqlMapper {

	static Logger log = Logger.getLogger(SqlMapper.class);
	
	private static Map<String, String> map;
	
	public static synchronized String getSql(String alias)
	{
		if(map == null)
			loadMap();
		if(map.containsKey(alias))
			return map.get(alias);
		else
			return null;
	}

	@SuppressWarnings("rawtypes")
	private static void loadMap() {
		map = new HashMap<String, String>();

		SAXReader reader = new SAXReader();
		InputStream module = SqlMapper.class.getClassLoader().getResourceAsStream("module.xml");
		try {
			if (module != null) {
				parseModule(module);
			}
			InputStream input = SqlMapper.class.getClassLoader().getResourceAsStream("sql.xml");
			if (input != null) {
				Document document = reader.read(input);
				Element root = document.getRootElement();
				for (Iterator it = root.elementIterator("sql"); it.hasNext();) {
					Element elm = (Element) it.next();
					String alias = elm.attribute("alias").getValue();
					String path = elm.attribute("path").getValue();
					map.put(alias, "/sqls/" + path);
				}
			}
		} catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}
	
	private static void parseModule (InputStream input) throws Exception{
		SAXReader reader = new SAXReader();
		Document document = reader.read(input);
		Element root = document.getRootElement();
		for (Iterator it = root.elementIterator("module"); it.hasNext();) {
			Element elm = (Element) it.next();
			String name = elm.attribute("name").getValue();
			putMap(name, reader, null);
			for (Iterator children = elm.elementIterator("module"); children.hasNext();) {
				Element childElm = (Element) children.next();
				String childname = childElm.attribute("name").getValue();
				putMap(childname, reader, name);
			}
		}
	}
	
	private static void putMap(String name, SAXReader reader, String parent) throws Exception {
		
		InputStream moduleSql = SqlMapper.class.getClassLoader().getResourceAsStream(parent == null ? name + "/sql.xml" : parent+"/"+name + "/sql.xml");
		if (moduleSql != null) {
			Document docSql = reader.read(moduleSql);
			Element rootSql = docSql.getRootElement();
			for (Iterator item = rootSql.elementIterator("sql"); item.hasNext();) {
				Element elmment = (Element) item.next();
				String aliasSql = elmment.attribute("alias").getValue();
				String pathSql = elmment.attribute("path").getValue();
				
				// 验证别名是否重复
				if (map.containsKey(aliasSql)){
					throw new Exception("别名"+ aliasSql + "已存在");
				}
				map.put(aliasSql, (parent == null ? name + "/sqls/" : parent + "/" + name + "/sqls/")+ pathSql);
			}
		}
	}
	
	public void main(String[] args) {
		SqlMapper.loadMap();
		for(String key : map.keySet())
			System.out.println(key);
	}
}
